#ifndef PBRT_WAVELENGTHFILTER_H
#define PBRT_WAVELENGTHFILTER_H

// wavelengthfilter.h*
#include "pbrt.h"
#include "color.h"

#define WAVELENGTH_SAMPLES 3
 
class WavelengthFilter {
public:
	WavelengthFilter() {
        i = 0;
    }
    void setIndex(int newIndex) {
        i = newIndex;
    }
    int index() const {
        return i;
    }
    float wavelength() const {
        return wavelengths[i];
    }
    void filterSpectrum(Spectrum *spec) const {
        *spec *= Spectrum(filters[i]);
    }
    bool isMonochromatic() const {
        return (i > 0);
    }
    
private:
    int i;
    
    static float filters[WAVELENGTH_SAMPLES+1][COLOR_SAMPLES];
    static float wavelengths[WAVELENGTH_SAMPLES+1];
};

#endif
