#include <stdio.h>
#include <stdlib.h>

struct vertex {
    float point[3];
};

int numVertices = 0;
struct vertex *vertices;

struct face {
    int vertexIndices[3];
} face;

int numFaces = 0;
struct face *faces;

void error(char *err) {
    printf("%s\n", err);
    exit(1);
}

void badFormat() {
    error("OBJ file had bad format");
}

int main(int argc, char *argv[]) {
    if (argc < 2)
        error("Usage:  OBJtoPBRT file.obj");
        
    FILE *infile = fopen(argv[1], "r");
    if (!infile)
        error("Couldn't open infile");
        
    char line[255];
    fgets(line, 100, infile);
    while (!feof(infile)) {
        if (strstr(line, "v "))
            numVertices++;
        else if (strstr(line, "f "))
            numFaces++;
        fgets(line, 100, infile);
    }
    rewind(infile);
    
    vertices = (struct vertex *)malloc(numVertices * sizeof(struct vertex));
    faces = (struct face *)malloc(numFaces * sizeof(struct face));
    int v = 0;
    int f = 0;
    
    char ch;
    int i;
    while (!feof(infile)) {
        ch = fgetc(infile);
        switch (ch) {
            case 'v':
                if (fgetc(infile) != ' ')
                    break;
                fscanf(infile, "%f %f %f", &vertices[v].point[0], &vertices[v].point[1], &vertices[v].point[2]);
                v++;
                break;
            case 'f':
                if (fgetc(infile) != ' ')
                    break;
                fscanf(infile, "%d %d %d", &faces[f].vertexIndices[0], &faces[f].vertexIndices[1], &faces[f].vertexIndices[2]);
                f++;
                break;
            default:
                break;
        }
        //fgets(line, 100, infile);
    }
    fclose(infile);
    
    char outfilename[100];
    strncpy(outfilename, argv[1], 99);
    char *dotPos = strchr(outfilename, '.');
    if (!dotPos)
        error("file doesn't have correct name");
    dotPos[0] = 0;
    strcat(outfilename, ".pbrt");
    
    FILE *outfile = fopen(outfilename, "w");
    if (!outfile)
        error("Couldn't open outfile");
        
    fprintf(outfile, "ReverseOrientation\n");
    fprintf(outfile, "Shape \"trianglemesh\"\n");
    fprintf(outfile, "\"point P\" [\n");
    for (i = 0; i < numVertices; i++)
        fprintf(outfile, "%f %f %f\n", vertices[i].point[0], vertices[i].point[1], vertices[i].point[2]);
    fprintf(outfile, "]\n");
    fprintf(outfile, "\"integer indices\" [\n");
    for (i = 0; i < numFaces; i++)
        fprintf(outfile, "%d %d %d\n", faces[i].vertexIndices[0]-1, faces[i].vertexIndices[1]-1, faces[i].vertexIndices[2]-1);
    fprintf(outfile, "]\n");
    
    fclose(outfile);
    printf("outputted to %s\n", outfilename);
    free(vertices);
    free(faces);
    return 0; 
}