#ifndef TRANSPORT_H
#define TRANSPORT_H
#include "lrt.h"
#include "photonmap.h"

enum INTEGRATOR_TYPE {OTHER_INTEGRATOR, MC_INTEGRATOR};

class Integrator {
public:
	virtual ~Integrator();
	virtual Spectrum L(const Scene *scene,
		const Ray &ray,	Float *alpha) const = 0;
    virtual void init() {pMap = NULL;type = OTHER_INTEGRATOR;}
    virtual void ActivatePhotonMap(Photon_map *pm) {pMap = pm;}
    virtual void ActivateGlobalPhotonMap(GlobalPhotonMap *gm) {gpMap = gm;}
    virtual void ActivateGlobalPhotonMapTerrain(GlobalPhotonMap *gm) {gpMapTerrain = gm;}
    Photon_map *pMap; 
    GlobalPhotonMap *gpMap;
    GlobalPhotonMap *gpMapTerrain;
    int type;
};
class RayCastingIntegrator : public Integrator {
public:
	Spectrum L(const Scene *scene, const Ray &ray,
		Float *alpha) const;
};
class WhittedIntegrator : public Integrator {
public:
	WhittedIntegrator(int md) {
		MaxDepth = md;
	}
	Spectrum L(const Scene *scene, const Ray &ray, Float *alpha = NULL) const;
	static int RayDepth;
private:
	int MaxDepth;
};
class PathIntegrator : public Integrator {
public:
	Spectrum L(const Scene *scene, const Ray &ray, Float *alpha) const;
};
class MCIntegrator : public Integrator {
public:
	Spectrum L(const Scene *scene, const Ray &ray, Float *alpha) const;
    virtual void init() {Integrator::init(); type = MC_INTEGRATOR;}
};
#endif // TRANSPORT_H
