#include "texture.h"
static StringHashTable textures;
TextureMap *GetTexture(const char *filename) {
	TextureMap *ret = (TextureMap *)textures.Search(filename);
	if (!ret) {
		ret = new TextureMap(filename);
		textures.Add(filename, ret);
	}
	return ret;
}
Spectrum UVTexture::evaluate(const Surf *surf) const {
	Float u = surf->dgShading.u, v = surf->dgShading.v;
	Point ptrans = xform(Point(u, v, 0.));
	return Spectrum( ptrans.x, ptrans.y, 0. );
}
TextureMap::TextureMap(const char *filename) {
	the_map = TIFFRead(filename, &width, &height);
}
TextureMap::~TextureMap() {
	delete[] the_map;
}
Spectrum TextureMap::Lookup(Float u, Float v) const {
	Float weights[4];
	if (!the_map) return Spectrum(1);
	u = Clamp(u, 0., 1.);
	v = Clamp(v, 0., 1.);
	Float xReal = u * (width-1);
	Float yReal = v * (height-1);
	int x = int(xReal);
	int y = int(yReal);
	Float dx = xReal - x;
	Float dy = yReal - y;
	weights[0] = (1.-dx)*(1.-dy);
	weights[1] = (1.-dx)*dy;
	weights[2] = dx*(1.-dy);
	weights[3] = dx*dy;
	Spectrum texels[4];
	texels[0] = the_map[y*width+x];
	if (y <height-1 && x < width-1) {
		texels[1] = the_map[(y+1)*width + x];
		texels[2] = the_map[y*width + x + 1];
		texels[3] = the_map[(y+1)*width + x + 1];
	} else if (y < height-1) {
		texels[1] = the_map[(y+1)*width + x];
		texels[2] = texels[3] = Spectrum(0);
	} else if (x < width-1) {
		texels[2] = the_map[y*width + x + 1];
		texels[1] = texels[3] = Spectrum(0);
	} else {
		texels[1] = texels[2] = texels[3] = Spectrum(0);
	}
	return weights[0]*texels[0] + weights[1]*texels[1] +
		weights[2]*texels[2] + weights[3]*texels[3];
}
