#include "scene.h"
#include "camera.h"
#include "primitives.h"
#include "image.h"
#include "transport.h"
#include "accel.h"
#include "sampling.h"
#include "photonmap.h"

Scene::~Scene() {
	delete camera;
	delete sampler;
	delete image;
	delete integrator;
}
Spectrum Scene::L(const Ray &ray) const {
	return integrator->L(this, ray, NULL);
}
bool Scene::IntersectP(const Ray &ray) const {
	return prims->IntersectP(ray);
}
Scene::Scene(Camera *cam, Integrator *in, Image *img, Sampler *s,
		const vector<Primitive *> &pr,
        const vector<Light *> &lts) : pMap(NULL) {
	lights = lts;
	prims = new GridAccelerator(pr);
	camera = cam;
	image = img;
	sampler = s;
	integrator = in;
}
void Scene::Render() {
	cerr << "Rendering: ";
    integrator->init();


      pMap = new Photon_map(this, 30000);
      pMap->make_photon_map();
      integrator->ActivatePhotonMap(pMap);

      gpMap = new GlobalPhotonMap(this, 300000);
      gpMap->make_photon_map();
      integrator->ActivateGlobalPhotonMap(gpMap);

      gpMapTerrain = new GlobalPhotonMap(this, 300000);
      gpMapTerrain->make_photon_map_terrain();
      integrator->ActivateGlobalPhotonMapTerrain(gpMapTerrain);


	Float sample[5];
	while (sampler->GetNextImageSample(sample)) {
		Ray ray;
		if (!camera->GenerateRay(sample, ray))
			continue;
		static int eyeRaysTraced = 0;
		if (eyeRaysTraced == 0)
			StatsRegisterCounter(STATS_BASIC, "Camera", "Eye Rays Traced",
				&eyeRaysTraced);
		++eyeRaysTraced;
		if (eyeRaysTraced % 10000 == 0) cerr << '+';
		Float alpha;
		Spectrum L = integrator->L(this, ray, &alpha);
		Float screenz = camera->WorldToScreen(ray(ray.maxt)).z;
		if (screenz > 1.) {
			L = 0.;
			alpha = 0.;
		}
		Point Praster(sample[0], sample[1], screenz);
		image->AddSample(Praster, L, alpha);
	}
	image->Write();
	cerr << endl;


    delete pMap;
    delete gpMap;
    delete gpMapTerrain;



}
bool Scene::Intersect(const Ray &ray, Surf *surf) const {
	return prims->Intersect(ray, surf);
}
