#ifndef MATERIALS_H
#define MATERIALS_H
#include "lrt.h"
#include "primitives.h"
enum MATERIAL_TYPE {OPAQUE, TRANSLUSCENT, TRANSLUSCENT_TERRAIN};

class Material {
public:
	virtual ~Material() { }
	virtual BSDF *getBSDF(const Surf *surf) const = 0;
	virtual DifferentialGeometry bump(const DifferentialGeometry &dgg) const;
    virtual int getType() {return OPAQUE;}
};
class Matte : public Material {
public:
	Matte(Texture<Spectrum> *kd) {
		Kd = kd;
	}
	~Matte();
	BSDF *getBSDF(const Surf *surf) const;
private:
	Texture<Spectrum> *Kd;
};
class Plastic : public Material {
public:
	~Plastic();
	Plastic(Texture<Spectrum> *kd, Texture<Spectrum> *ks,
			Texture<Float> *rough) {
		Kd = kd;
		Ks = ks;
		roughness = rough;
	}
	BSDF *getBSDF(const Surf *surf) const;
private:
	Texture<Spectrum> *Kd, *Ks;
	Texture<Float> *roughness;
};
class Glass : public Material {
public:
	~Glass();
	Glass(Texture<Spectrum> *r, Texture<Spectrum> *t,
			Texture<Float> *i) {
		Kr = r;
		Kt = t;
		index = i;
	}
	BSDF *getBSDF(const Surf *surf) const;
private:
	Texture<Spectrum> *Kr, *Kt;
	Texture<Float> *index;
};


class ShinyMetal : public Material {
public:
	~ShinyMetal();
	ShinyMetal(Texture<Spectrum> *ks, Texture<Float> *rough,
			Texture<Spectrum> *kr) {
		Ks = ks;
		roughness = rough;
		Kr = kr;
	}
	BSDF *getBSDF(const Surf *surf) const;
private:
	Texture<Spectrum> *Ks, *Kr;
	Texture<Float> *roughness;
};

class Transluscent : public Material {
public:
	~Transluscent();
	Transluscent(Texture<Spectrum> *d, Float i, Spectrum sgS, Spectrum sgA, Float meancosine)
    {
	    Kd = d;		
	    index = i;       
        sigS = sgS;
        sigA = sgA;
        g = meancosine;
	}
	BSDF *getBSDF(const Surf *surf) const;
    virtual int getType() {return TRANSLUSCENT;}
    Float index, g;
    Spectrum sigS, sigA;
private:
	Texture<Spectrum> *Kd;
};

class TransluscentTerrain : public Material {
public:
	~TransluscentTerrain();
	TransluscentTerrain(Texture<Spectrum> *d, Float i, Spectrum sgS, Spectrum sgA, Float meancosine)
    {
	    Kd = d;		
	    index = i;       
        sigS = sgS;
        sigA = sgA;
        g = meancosine;
	}
	BSDF *getBSDF(const Surf *surf) const;
    virtual int getType() {return TRANSLUSCENT_TERRAIN;}
    Float index, g;
    Spectrum sigS, sigA;
private:
	Texture<Spectrum> *Kd;
};

#endif // MATERIALS_H
