#ifndef HEIGHTFIELD_H
#define HEIGHTFIELD_H
#include "shapes.h"
#include <vector>

class Heightfield : public Shape {
public:
	Heightfield(const Transform &o2w, int nu, int nv, float *zs);
	~Heightfield();
	virtual bool CanIntersect() const;
	virtual void Refine(vector<Shape *> &refined) const;
	virtual BBox Bound() const;
	virtual bool Intersect(const Ray &ray, DifferentialGeometry *dg) const;
	virtual bool IntersectP(const Ray &ray) const;

	// returns intersection points with bounding box
    bool TriIntersectTest(const Ray& r, int i, int j, 
			  DifferentialGeometry *dg) const;
    bool IntersectTest(const Ray &r, const Ray& ray, 
		       DifferentialGeometry *dg) const;

    bool intersect_triangle(const Ray& ray, const Point& pp0, 
	      const Point& pp1, const Point& pp2,  DifferentialGeometry *dg, 
			    int i0, int i1, int i2) const;
    void CalculatePhongNormals();

 private:
	float *z;    
	int nx, ny;
    float _gWidthX, _gWidthY;
	std::vector<Normal> _phongNormal;
	bool _bbExists;
	BBox _bb; // bounding box of height field
};

#endif
