function result = lin_interp(pos, S0)

global x;
global y;
global z;
dx(1) = x(2)-x(1);
dx(2) = y(2)-y(1);
dx(3) = z(2)-z(1);

realind = ((pos+dx)./dx);
ind = floor(realind);
indplusone = ind+1;


sizes = size(S0);
for (i=1:3)
    if (indplusone(i) > sizes(i))
        indplusone(i) = 1;
    end
end
diff = realind - ind;
V000 = S0(ind(1), ind(2), ind(3));
V100 = S0(indplusone(1), ind(2), ind(3));
V010 = S0(ind(1), indplusone(2), ind(3));
V001 = S0(ind(1), ind(2), indplusone(3));
V101 = S0(indplusone(1), ind(2), indplusone(3));
V011 = S0(ind(1), indplusone(2), indplusone(3));
V110 = S0(indplusone(1), indplusone(2), ind(3));
V111 = S0(indplusone(1), indplusone(2), indplusone(3));

result = V000*(1-diff(1))*(1-diff(2))*(1-diff(3)) +...
    V100*diff(1)*(1-diff(2))*(1-diff(3)) +...
    V010*(1-diff(1))*diff(2)*(1-diff(3)) +...
    V001*(1-diff(1))*(1-diff(2))*diff(3) +...
    V101*diff(1)*(1-diff(2))*diff(3) +...
    V011*(1-diff(1))*diff(2)*diff(3) +...
    V110*diff(1)*diff(2)*(1-diff(3)) +...
    V111*diff(1)*diff(2)*diff(3);


return