#ifndef TRANSFORM_H
#define TRANSFORM_H
#include "lrt.h"
#include "geometry.h"
#include "color.h"

class Transform {
public:
	Transform(Float t00=1, Float t01=0, Float t02=0, Float t03=0,
	          Float t10=0, Float t11=1, Float t12=0, Float t13=0,
	          Float t20=0, Float t21=0, Float t22=1, Float t23=0,
	          Float t30=0, Float t31=0, Float t32=0, Float t33=1 );
	Transform( Float *m );
	Transform( Float m[4][4] );
	bool operator!=(const Transform &t2) const;
	friend ostream &operator<<(ostream &, const Transform &);
	Transform operator*(const Transform &t2) const;
	Point operator()(const Point &pt) const;
	Vector operator()(const Vector &v) const;
	void ComputeInverse(void);
	Float *GetInverse(void) { return &(m_inverse[0][0]); }
	Normal operator()(const Normal &) const;
	Ray operator()(const Ray &r) const;
	BBox operator()(const BBox &b) const;
	DifferentialGeometry operator()(const DifferentialGeometry &dg) const;
private:
	Float m[4][4];
	Float m_inverse[4][4];
};
#endif // TRANSFORM_H
