#ifndef HEIGHTFIELD_H
#define HEIGHTFIELD_H
#include "shapes.h"

class Heightfield : public Shape {
public:
	Heightfield(const Transform &o2w, int nu, int nv, float *zs);
	~Heightfield();
	virtual bool CanIntersect() const;
	virtual void Refine(vector<Shape *> &refined) const;
	virtual BBox Bound() const;
	virtual bool IntersectP(const Ray& ray) const;
	virtual bool Intersect(const Ray&, DifferentialGeometry *dg) const;
	BBox* bounds;
private:
	float *z;
	int nx, ny;
	bool TraverseHeightfield(Ray &ray, const Ray& origRay, DifferentialGeometry *dg) const;
	bool VisitedCell(const Ray &ray, DifferentialGeometry *dg, int x, int y)
	  const;
	Vector GrabNormal(int x, int y) const;
	Vector GetPoint(int x, int y) const;
	Vector *ns;

};

#endif
