#ifndef DENSITYGRID_H
#define DENSITYGRID_H
#include "shapes.h"
#include "MathLib.h"
#include <rfftw.h>

typedef Float RGBA[4];

class DensityGrid {
public:
  DensityGrid(const Transform &o2w, Float _maxX, Float _maxY,
	      Float _maxZ, int _xRes, int _yRes, int _zRes);
  ~DensityGrid();

  fftw_real Max[3];
  int N[3];
  fftw_real D[3];

  //RGBA *densities;
  fftw_real *U0[3], *U1[3], *F[3];
  float* S2;
  float* intensities;
  fftw_real *source;
  Float kS, aS, visc;
  Float dt;
  Vector lightDir;

  int maxTime;

  void Populate();
  void Init();
  void InitFFT();
  void PrintGrid(fftw_real* grid);
  void FFT(int s, void* u);
  void AddForce(fftw_real* arr, fftw_real* forces, Float dt);
  void Dissipate(fftw_real* S1, fftw_real* S0, Float diss, Float dt);
  void Project(fftw_real* S1[], fftw_real* S0[], Float dt);
  void Diffuse(fftw_real* S1, fftw_real* S0, Float diff, Float dt);
  void Transport(fftw_real* S1, fftw_real* S0, fftw_real* vels[], Float
  dt);
  void TraceParticle(Float x[], fftw_real* vels[], Float dt, Float x0[]);
  void Vstep(fftw_real* U1[], fftw_real* U0[], 
	     Float visc, fftw_real* F[], Float dt);
  void SStep(fftw_real* S1, fftw_real* S0, Float kS, Float
	     aS, fftw_real* U1[], fftw_real* source, Float dt);
  void Normalize(fftw_real*S1);
  Float LinInterp(Float p[], float*S0);
  Spectrum L(const Scene* scene, const Ray& ray, Float &alpha);
  Transform ObjectToWorld, WorldToObject;
  BBox* bounds;
  rfftwnd_plan plan_rc, plan_cr;
  
};

#endif
