#include "densitygrid.h"
#include <stdlib.h>
#include <stdio.h>
#include "geometry.h"
#include <time.h>
#include <rfftw.h>
#include <tiffio.h>
#include "lrt.h"
#include "color.h"

#define ARR(a,x,y,z) a[z+N[2]*(y+(N[1]*x))]
#define CPX_ARR(a,x,y,z) a[z+((N[2]/2)+1)*(y+(N[1])*x)]

#define ATT_CONSTANT 3

extern char filename[64];

DensityGrid::DensityGrid(const Transform &o2w, Float _maxX, Float _maxY,
			 Float _maxZ, int _xRes, int _yRes, int _zRes)
	: ObjectToWorld(o2w) {
  WorldToObject = Transform(ObjectToWorld.GetInverse());
  int i, j;

  Max[0] = _maxX;
  Max[1] = _maxY;
  Max[2] = _maxZ;
  N[0] = _xRes;
  N[1] = _yRes;
  N[2] = _zRes;

  int realZRes = 2*(N[2]/2 + 1);

  printf("%d %d\n", N[2], realZRes);

  D[0] = Max[0]/N[0];
  D[1] = Max[1]/N[1];
  D[2] = Max[2]/N[2];

  S2 = (float*)malloc(N[0]*N[1]*N[2]*sizeof(float));
  intensities = (float*)malloc(N[0]*N[1]*N[2]*sizeof(float));
    
  kS = 0.0001;
  aS = 1;
  visc = 2;

  dt = 0.1;
  maxTime = 2;

  bounds = new BBox(Point(0,0,0), Point(Max[0], Max[1], Max[2]));

  //define the light direction
  lightDir = Vector(0,1,0);
  lightDir = WorldToObject(lightDir);

  //now read in the heightfield

  int sizeX, sizeY;
  printf("blah");
  Spectrum* heightColors = TIFFRead("height.tif", &sizeX, &sizeY);
  printf("size X: %d, sizeY: %d\n", sizeX, sizeY);
  /*  FILE* heightfile = fopen("yarland.rib", "w");
  for (i=0; i<sizeX; i++)
    {
      for (j=0; j<sizeY; j++)
	{
	  float rgb[3];
	  heightColors[i*sizeX+j].ConvertToRGB(rgb);
	  fprintf(heightfile, "%g ", rgb[0]);
	}
      fprintf(heightfile, "\n");
    }
    fclose(heightfile);*/
}

void DensityGrid::InitFFT()
{
  plan_rc = rfftw3d_create_plan(N[0], N[1], N[2], FFTW_REAL_TO_COMPLEX, FFTW_IN_PLACE);
  plan_cr = rfftw3d_create_plan(N[0], N[1], N[2], FFTW_COMPLEX_TO_REAL, FFTW_IN_PLACE);
}

void DensityGrid::FFT(int s, void* u)
{
  if (s==1) rfftwnd_one_real_to_complex(plan_rc, (fftw_real*)u, (fftw_complex*)u);
  else rfftwnd_one_complex_to_real(plan_cr, (fftw_complex*)u, (fftw_real*)u);
}

void DensityGrid::Init()
{
  int i, j, k, l;


}

void Swap(void** arr1, void** arr2)
{
  char* temp;
  temp = (char*)(*arr1);
  (*arr1) = (*arr2);
  (*arr2) = temp;
}

void DensityGrid::AddForce(fftw_real* arr, fftw_real* forces, Float dt)
{
}

void DensityGrid::Dissipate(fftw_real* S1, fftw_real* S0, Float diss, Float dt)
{
}

void DensityGrid::Project(fftw_real* S1[], fftw_real* S0[], Float dt)
{
}

void DensityGrid::Diffuse(fftw_real* S1, fftw_real* S0, Float diff, Float dt)
{
}

#define INDEX(x, i) (x/D[i])

void DensityGrid::TraceParticle(Float x[], fftw_real *vels[], Float dt,
				Float x0[])
{
}


Float DensityGrid::LinInterp(Float p[], float* S0)
{
  int i;
  Float terp[3];
  int terpint[3];
  int terpplusone[3];
  Float result;
  Float diff[3];
  for (i=0; i<3; i++)
    {
      terp[i] = INDEX(p[i], i);
      terpint[i] = INDEX(p[i], i);
      terpplusone[i] = (terpint[i]+1)%N[i];
      diff[i] = terp[i] - terpint[i];
    }
  Float V000 = ARR(S0, terpint[0], terpint[1], terpint[2]);
  Float V100 = ARR(S0, terpplusone[0], terpint[1], terpint[2]);
  Float V010 = ARR(S0, terpint[0], terpplusone[1], terpint[2]);
  Float V001 = ARR(S0, terpint[0], terpint[1], terpplusone[2]);
  Float V101 = ARR(S0, terpplusone[0], terpint[1], terpplusone[2]);
  Float V011 = ARR(S0, terpint[0], terpplusone[1], terpplusone[2]);
  Float V110 = ARR(S0, terpplusone[0], terpplusone[1], terpint[2]);
  Float V111 = ARR(S0, terpplusone[0], terpplusone[1], terpplusone[2]);

  result = (V000*(1-diff[0])*(1-diff[1])*(1-diff[2])) +
    (V100*(diff[0])*(1-diff[1])*(1-diff[2])) +
    (V010*(1-diff[0])*(diff[1])*(1-diff[2])) +
    (V001*(1-diff[0])*(1-diff[1])*(diff[2])) +
    (V101*(diff[0])*(1-diff[1])*(diff[2])) +
    (V011*(1-diff[0])*(diff[1])*(diff[2])) +
    (V110*(diff[0])*(diff[1])*(1-diff[2])) +
    (V111*(diff[0])*(diff[1])*(diff[2]));


  return result;
}

void DensityGrid::Transport(fftw_real* S1, fftw_real* S0, fftw_real* vels[], Float dt)
{
}

void DensityGrid::Normalize(fftw_real* S1)
{
}

void DensityGrid::Vstep(fftw_real* U1[], fftw_real* U0[], Float visc, fftw_real* F[], Float dt)
{
}

void DensityGrid::PrintGrid(fftw_real*S1)
{
  int i, j, k;
  i =5;
  //  for (i=0; i<N[2]; i++)
    {
      for (j=0; j<N[0]; j++)
	{
	  for (k=0; k<N[1]; k++)
	    {
	      printf("%5.2g ", ARR(S1, j, k, i));
	    }
	  printf("\n");
	}
      printf("\n");
    }
}

void DensityGrid::SStep(fftw_real* S1, fftw_real* S0, Float kS, Float aS, fftw_real* U1[],
			fftw_real* source, Float dt)
{
}

#define DT 0.1

void DensityGrid::Populate()
{
  double t;

  Init();
  
  FILE* densityFile = fopen(filename, "r");
  printf("%s\n", filename);
  if (densityFile == NULL)
    {
      printf("fuck"); exit(0);
    }
  int i, j, k;
  for (i=0; i<N[0]; i++)
    {
      for (j=0; j<N[1]; j++)
	{
	  for (k=0; k<N[2]; k++)
	    {
	      fscanf(densityFile, "%g", &(ARR(S2, i, j ,k)));
	    }
	}
    }
  // calculate the intensity grid
  for (i=0; i<N[0]; i++)
    {
      for (j=0; j<N[1]; j++)
	{
	  for (k=0; k<N[2]; k++)
	    {
	      Vector direction = lightDir;
	      Ray lightRay(Point(i*D[0], j*D[1], 
				 k*D[2]), direction);
	      t=0;
	      float total =0;
	      while (1)
		{
		  Point p = lightRay(t);
		  if (!bounds->Inside(p)) break;
		  Float pt[3];
		  pt[0] = p.x;
		  pt[1] = p.y;
		  pt[2] = p.z;		  
		  total += LinInterp(pt, S2)*DT*0.1;
		  t+=DT;
		}
	      ARR(intensities, i, j, k) = exp(-ATT_CONSTANT*total);
	      
	    }
	}

      srand(time(NULL));
    }
}
#define G -0.3

double RandomReal(double low, double high)
{
  return(rand()/RAND_MAX)*(high-low)+low;
}

float Scatter(Vector V1, Vector V2)
{
  float costheta = Dot(V1,V2)/(V1.Length()*V2.Length());
  return (1-G*G)/((4*M_PI)*pow(1+G*G-(2*G*costheta), 1.5));
}

Spectrum DensityGrid::L(const Scene* scene, const Ray& ray, Float& alpha)
{
  Ray rt = WorldToObject(ray);
  Ray tempRay = rt;
  Float t, startT, endT;
  Spectrum color(40.);
  Float brightness;
  
  if (!bounds->IntersectP(rt))
    {
      alpha = 0;
    }
  else
    {
      //here's where we sum the densities
      t = startT = rt.maxt;
      while (1)
	{
	  t+=DT;
	  Point p = rt(t);
	  //	  printf("point p = %g %g %g\n", p.x, p.y, p.z);
	  if (!bounds->Inside(p)) break;
	}
      endT = t;
      alpha = 0;
      brightness = 0;
      for (t = startT; t<endT; t+=DT)
	{
	  float attenuation, density, intensity; 
	  Point p = rt(t);
	  Float pt[3];
	  pt[0] = p.x;
	  pt[1] = p.y;
	  pt[2] = p.z;
	  Float rgb[3];
	  color.ConvertToRGB(rgb);
     
	  density = LinInterp(pt, S2) * DT * 0.2;
	  alpha+=density;
	  attenuation = exp(-ATT_CONSTANT*alpha);

	  intensity = LinInterp(pt, intensities);
	  intensity *= Scatter(rt.D, lightDir);
	  //	  printf("%g %g %g\n", attenuation, intensity, density);
	  
	  brightness += (attenuation * intensity * density);
	}
    }
  brightness*=100;

  //  return Spectrum(0.5, 0.4, 0.2);
  return Spectrum(0.25+brightness*.75, 
		  0.2+brightness*.6, 
		  0.1+brightness*0.3);
}
