/*
 * This file highjacks the typical nurbs.cc call to create a triangle mesh
 * from a RIB file containing a nurbs shape.  This file creates a trianglemesh
 * but it adds in uv texture coordinates so that nurbs can have reasonable
 * mapping.  The texutre coodinates are calculated by assuming the shape is flat.
 */


#include "nurbstrianglemesh.h"

NurbsTriangleMesh::NurbsTriangleMesh(const Transform &o2w, int nt, int nv,
		int *vi, Point *P, Float uMin, Float uMax, Float vMin, Float vMax)
	: TriangleMesh(o2w, nt, nv, vi, P) {
	//find the range of the real coordinates so
	//it can be maped to UV coordinates.
	Point pt = WorldToObject(p[0]);
	umin = pt.x;
	umax = pt.x;
	vmin = pt.z;
	vmax = pt.z;
	for(int i = 0; i < nv; i++) {
		pt = WorldToObject(p[i]);
		if(pt.x < umin) umin = pt.x;
		if(pt.x > umax) umax = pt.x;
		if(pt.z < vmin) vmin = pt.z;
		if(pt.z > vmax) vmax = pt.z;
	}
}

void NurbsTriangleMesh::Refine(vector<Shape *> &refined) const {
	Float tx[3][2];
	BBox bb = Bound();
	Float uRange = bb.pMax.x - bb.pMin.x;
	Float vRange = bb.pMax.z - bb.pMin.z;
	for (int i = 0; i < ntris; ++i) {
		int *vptr = &(vertexIndex[3*i]);
		int vertexIndex0 = *vptr++;
		int vertexIndex1 = *vptr++;
		int vertexIndex2 = *vptr++;
		
		//calc the uv's for each vertex.
		tx[0][0] = (p[vertexIndex0].x-bb.pMin.x)/uRange;
		tx[0][1] = (p[vertexIndex0].z-bb.pMin.z)/vRange;
		tx[1][0] = (p[vertexIndex1].x-bb.pMin.x)/uRange;
		tx[1][1] = (p[vertexIndex1].z-bb.pMin.z)/vRange;
		tx[2][0] = (p[vertexIndex2].x-bb.pMin.x)/uRange;
		tx[2][1] = (p[vertexIndex2].z-bb.pMin.z)/vRange;

		refined.push_back(new Triangle(ObjectToWorld, this, i, (Float *)tx));
	}
}
