#ifndef MATERIALS_H
#define MATERIALS_H
#include "lrt.h"
#include "primitives.h"

// RRG
#include "heightfield.h"
#include "transform.h"

class Material 
{
 public:
  virtual ~Material() { }
  virtual BSDF *getBSDF(const Surf *surf) const = 0;
  virtual DifferentialGeometry bump(const DifferentialGeometry &dgg) const;
};

class Matte : public Material 
{
 public:
  Matte(Texture<Spectrum> *kd) 
    {
      Kd = kd;
      
      Transform iden;
      myField = new Heightfield(iden, 0, 0, NULL, true);
    }
  
  ~Matte();
  BSDF *getBSDF(const Surf *surf) const;
  virtual DifferentialGeometry bump(const DifferentialGeometry &dgg) const;

 private:
  Texture<Spectrum> *Kd;

  // RRG
  Heightfield *myField;
};


class Plastic : public Material {
public:
	~Plastic();
	Plastic(Texture<Spectrum> *kd, Texture<Spectrum> *ks,
			Texture<Float> *rough) {
		Kd = kd;
		Ks = ks;
		roughness = rough;
	}
	BSDF *getBSDF(const Surf *surf) const;
private:
	Texture<Spectrum> *Kd, *Ks;
	Texture<Float> *roughness;
};
class Glass : public Material {
public:
	~Glass();
	Glass(Texture<Spectrum> *r, Texture<Spectrum> *t,
			Texture<Float> *i) {
		Kr = r;
		Kt = t;
		index = i;
	}
	BSDF *getBSDF(const Surf *surf) const;
private:
	Texture<Spectrum> *Kr, *Kt;
	Texture<Float> *index;
};
class ShinyMetal : public Material {
public:
	~ShinyMetal();
	ShinyMetal(Texture<Spectrum> *ks, Texture<Float> *rough,
			Texture<Spectrum> *kr) {
		Ks = ks;
		roughness = rough;
		Kr = kr;
	}
	BSDF *getBSDF(const Surf *surf) const;
private:
	Texture<Spectrum> *Ks, *Kr;
	Texture<Float> *roughness;
};
class AbaloneShell : public Material {
public:
	~AbaloneShell();
	AbaloneShell(Texture<Spectrum> *ks, Texture<Float> *rough,
			Texture<Spectrum> *kr) {
		Ks = ks;
		roughness = rough;
		Kr = kr;

		// RRG
		Transform iden;
		myField = new Heightfield(iden, 0, 0, NULL, true);

	}
	BSDF *getBSDF(const Surf *surf) const;
	virtual DifferentialGeometry bump(const DifferentialGeometry &dgg) const;

private:
	Texture<Spectrum> *Ks, *Kr;
	Texture<Float> *roughness;

	// RRG
	Heightfield *myField;
};

#endif // MATERIALS_H
