#ifndef HEIGHTFIELD_H
#define HEIGHTFIELD_H

#include "shapes.h"
#include "fractal.h"

typedef enum {S_PX, S_NX, S_PY, S_NY, S_Z, S_QUAD1, S_QUAD2, S_QUAD3, S_QUAD4, S_ERROR} SlopeType;

// Sand-related
#define DEGREE 513

class Heightfield : public Shape 
{
 public:
  Heightfield(const Transform &o2w, int nu, int nv, float *zs, bool forBumpMap = false);
  ~Heightfield();
  virtual bool CanIntersect() const;
  
  // RRG: Implementation of the intersect routine. 
  virtual bool Intersect(const Ray &origRay, DifferentialGeometry *dg) const;
  bool CheckTris(const Ray &ray, const Point &gridPt, DifferentialGeometry *dg) const;
  SlopeType GetSlopeType(const Ray &ray) const;
  Point CellBox(SlopeType sType, const Point &gridPt) const;
  float Traverse(const Ray &ray, const Point &gridPt, float raySlope, SlopeType sType) const;
  virtual TriangleMesh *Triangulate(int myX, int myY, bool tri1, bool tri2, Vector &norms, int &num) const;
  virtual void Refine(vector<Shape *> &refined) const;
  virtual BBox Bound() const;
  bool CheckZs(int minX, int minY, const Ray &ray) const;

  Vector GetVertexNormal(int x, int y) const;
  Normal PhongIt(int cX, int cY, float posX, float posY, int index) const;
  
  // Added sand/bump-mapping functions.
  Fractal *myFractal;
  bool HelperFunc(int minX, int minY, DifferentialGeometry *dg, const Ray &ray) const;
  Normal Bump(float u, float v);


 private:
  float *z;
  int nx, ny;
  
  // RRG
  BBox *mBBox;

  // ray(time + error) used to push the generated point 
  // slightly inside a grid cell, instead of leaving it
  // on the edge. 

  float error;
};

#endif
