#ifndef ABALONE_H
#define ABALONE_H
#include "lrt.h"
#include "geometry.h"
#include "reflection.h"



class AbaloneMicrofacet : public BxDF {
public:
	AbaloneMicrofacet(const Spectrum &reflectance, MicrofacetDistribution *d, const DifferentialGeometry *dg);
	~AbaloneMicrofacet();
	Spectrum f(const Vector &wi, const Vector &wo) const;
	Float G(const Vector &wi, const Vector &wo) const {
		return 1.f;
	}
	Float F(const Vector &wi, const Vector &wo) const {
		return 1.f;
	}
	virtual void sample_f(const Vector &wi, Vector *wo) const;
	virtual Float weight(const Vector &wi, const Vector &wo) const;
private:
	Spectrum AbaloneMicrofacet::BackGroundColor(const Vector &wi, const Vector &wo) const;
	Float u, v;
	Spectrum R;
	Normal N;
	MicrofacetDistribution *distribution;
};


#endif // ABALONE_H