#include "scene.h"
#include "camera.h"
#include "primitives.h"
#include "image.h"
#include "transport.h"
#include "accel.h"
#include "sampling.h"
#include "reflection.h"

Scene::~Scene() {
	delete camera;
	delete sampler;
	delete image;
	delete integrator;
}
Spectrum Scene::L(const Ray &ray) const {
	return integrator->L(this, ray, NULL);
}
bool Scene::IntersectP(const Ray &ray) const {
	return prims->IntersectP(ray);
}
Scene::Scene(Camera *cam, Integrator *in, Image *img, Sampler *s,
		const vector<Primitive *> &pr,
		const vector<Light *> &lts) {
	lights = lts;
	prims = new GridAccelerator(pr);
	camera = cam;
	image = img;
	sampler = s;
	integrator = in;

	//NEW STUFF
	SetPhotonCounts(20000);
	pmap = new PhotonMap(nPhotons+1);
	cmap = new PhotonMap(5*nPhotons+1);
	imap = new PhotonMap(5*nPhotons+1);
	envmap = new PhotonMap(200*nPhotons+1);
	//END NEW STUFF
}
void Scene::Render() {
	cerr << "Rendering: ";
	Float sample[5];


	//NEW STUFF
		EmitPhotons();
		pmap->BuildTree();
		cmap->BuildTree();
		imap->BuildTree();
		envmap->BuildTree();
	//END NEW STUFF
	BBox bounds = GetSceneBounds();
	printf("\nBOUNDS");
	printf(" %f %f %f %f %f %f",bounds.pMin.x,bounds.pMin.y,bounds.pMin.z,bounds.pMax.x,bounds.pMax.y,bounds.pMax.z);


	while (sampler->GetNextImageSample(sample)) {
		Ray ray;
		if (!camera->GenerateRay(sample, ray))
			continue;
		static int eyeRaysTraced = 0;
		if (eyeRaysTraced == 0)
			StatsRegisterCounter(STATS_BASIC, "Camera", "Eye Rays Traced",
				&eyeRaysTraced);
		++eyeRaysTraced;
		if (eyeRaysTraced % 10000 == 0) cerr << '+';
		Float alpha;
		Spectrum L(0.);
		Spectrum S;
		Surf s;
		L = integrator->L(this, ray, &alpha);
		 Float screenz = camera->WorldToScreen(ray(ray.maxt)).z;
		  if (screenz > 1.) {
		   L = 0.;
		    alpha = 0.;
		 }

		  Point Praster(sample[0], sample[1], screenz);
		  image->AddSample(Praster, L, alpha);
		}
		image->Write();
		cerr << endl;
}


bool Scene::Intersect(const Ray &ray, Surf *surf) const {
	return prims->Intersect(ray, surf);
}



void Scene::SetPhotonCounts(int total)
{
  nPhotons = total;
  float totalint=0.f,localint=0.f;
  int localphotons;
  int i;
  for (i=0;i<(int)lights.size();i++) {
    totalint+=lights[i]->GetIntensity();
  }
  for (i=0;i<(int)lights.size();i++) {
    localint = lights[i]->GetIntensity();
    localphotons = (localint/totalint)*total;
    lights[i]->SetPhotonCount(localphotons);
  }
}

void Scene::EmitPhotons()
{
  for (int i=0;i<(int)lights.size();i++) {
    lights[i]->EmitPhotons(this);
  }
}
