#ifndef PMAP_H
#define PMAP_H
#include "lrt.h"
#include "transform.h"

typedef struct {
  float pos[3];
  float pow[3];
  unsigned char theta;
  unsigned char phi;
  short kdtree;
} Photon;

typedef struct {
  int max;
  int numFound;
  int gotHeap;
  float pos[3];
  float *distSquared;
  const Photon **index;
} PhotonStack;

class PhotonMap {
 public:
  PhotonMap(int maxP);
  ~PhotonMap();

  void Insert(const Point p, const float pw[3], const Vector v);
  void ScalePow(const float scale);
  void BuildTree();
  void GetIrradiance(float ir[3], const Point p, const Normal n, const float mDist,
		     const int nPhot) const;
  void LocatePhotons(PhotonStack *const ps, const int index) const;
  void PhotonDir(float *dir, const Photon *p) const;

 private:
  void BalanceSegment(Photon **t1, Photon **t2, const int index,
		      const int start, const int end);
  void MedianSplit(Photon **p, const int start, const int end,
		   const int median, const int axis);

  Photon *photons;
  int numStored;
  int halfStored;
  int maxPhotons;
  int lastScale;

  float cost[256];
  float sint[256];
  float cosp[256];
  float sinp[256];

  float min[3];
  float max[3];
};

#endif
