#ifndef SCENE_H
#define SCENE_H
#include "lrt.h"
#include "photonmap.h"

class Scene {
public:
	Scene(Camera *c, Integrator *in, Image *img, Sampler *s,
		const vector<Primitive *> &prims, const vector<Light *> &lts,
                const int numCaustic, const int numVolume );
	Spectrum L(const Ray &ray) const;
	bool Intersect(const Ray &ray, Surf *surf) const;
        bool SafeIntersect( const Ray & ray, Surf * startSurf, Surf * surf ) const;
	bool IntersectP( const Ray &ray ) const;
	void Render();
	~Scene();
	Integrator *integrator;
	Camera *camera;
	Image *image;
	Sampler *sampler;
	vector<Light *> lights;
        PhotonMap * causticPhotonMap;
        PhotonMap * volumePhotonMap;
private:
        void BuildCausticPhotonMap();
        void BuildVolumePhotonMap();
	PrimitiveSet *prims;
        int numCausticPhotons;
        int numVolumePhotons;
};
#endif // SCENE_H
