/* A Bison parser, made from ribparse.y
   by GNU bison 1.35.  */

#define YYBISON 1  /* Identify Bison output.  */

# define	STRING	257
# define	ID	258
# define	NUM	259
# define	LBRACK	260
# define	RBRACK	261
# define	DASH	262
# define	AREALIGHTSOURCE	263
# define	ATMOSPHERE	264
# define	ATTRIBUTE	265
# define	ATTRIBUTEBEGIN	266
# define	ATTRIBUTEEND	267
# define	BASIS	268
# define	BOUND	269
# define	CLIPPING	270
# define	COLOR	271
# define	COLORSAMPLES	272
# define	CONCATTRANSFORM	273
# define	CONE	274
# define	COORDINATESYSTEM	275
# define	CROPWINDOW	276
# define	CYLINDER	277
# define	DECLARE	278
# define	DEFORMATION	279
# define	DEPTHOFFIELD	280
# define	DETAIL	281
# define	DETAILRANGE	282
# define	DISK	283
# define	DISPLACEMENT	284
# define	DISPLAY	285
# define	EXPOSURE	286
# define	EXTERIOR	287
# define	FORMAT	288
# define	FRAMEASPECTRATIO	289
# define	FRAMEBEGIN	290
# define	FRAMEEND	291
# define	GENERALPOLYGON	292
# define	GEOMETRICAPPROXIMATION	293
# define	GEOMETRY	294
# define	HIDER	295
# define	HYPERBOLOID	296
# define	IDENTITY	297
# define	ILLUMINATE	298
# define	IMAGER	299
# define	INTERIOR	300
# define	LIGHTSOURCE	301
# define	MAKEBUMP	302
# define	MAKECUBEFACEENVIRONMENT	303
# define	MAKELATLONGENVIRONMENT	304
# define	MAKESHADOW	305
# define	MAKETEXTURE	306
# define	MARTINIGLASSCONTOUR	307
# define	MATTE	308
# define	MOTIONBEGIN	309
# define	MOTIONEND	310
# define	NUPATCH	311
# define	OBJECTBEGIN	312
# define	OBJECTEND	313
# define	OBJECTINSTANCE	314
# define	OPACITY	315
# define	OPTION	316
# define	ORIENTATION	317
# define	PARABOLOID	318
# define	PATCH	319
# define	PATCHMESH	320
# define	PERSPECTIVE	321
# define	PIXELFILTER	322
# define	PIXELSAMPLES	323
# define	PIXELVARIANCE	324
# define	POINTSGENERALPOLYGONS	325
# define	POINTSPOLYGONS	326
# define	POLYGON	327
# define	PROJECTION	328
# define	QUANTIZE	329
# define	RECTANGLE	330
# define	RELATIVEDETAIL	331
# define	REVERSEORIENTATION	332
# define	ROTATE	333
# define	SCALE	334
# define	SCREENWINDOW	335
# define	SHADINGINTERPOLATION	336
# define	SHADINGRATE	337
# define	SHUTTER	338
# define	SIDES	339
# define	SKEW	340
# define	SOLIDBEGIN	341
# define	SOLIDEND	342
# define	SPHERE	343
# define	SURFACE	344
# define	TEXTURECOORDINATES	345
# define	TORUS	346
# define	TRANSFORM	347
# define	TRANSFORMBEGIN	348
# define	TRANSFORMEND	349
# define	TRANSLATE	350
# define	TRIMCURVE	351
# define	VERSION	352
# define	WORLDBEGIN	353
# define	WORLDEND	354
# define	HIGH_PRECEDENCE	355

#line 1 "ribparse.y"

#include "ri.h"
#include "lrt.h"

#include <stdarg.h>

extern int yylex( void );
int line_num = 1;

#define YYMAXDEPTH 100000000

void yyerror( char *str ) {
	Error( "RIB parsing error on line %d\n\t%s", line_num,str );
}

void ParseError( const char *format, ... ) PRINTF_FORMAT;

void ParseError( const char *format, ... ) {
	char error[4096];
	va_list args;
	va_start( args, format );
	vsprintf( error, format, args );
	yyerror(error);
	va_end( args );
}

// RI says 64k is the maxiumum light handle number
#define MAX_LIGHT_HANDLE 65536
static RtLightHandle lights[MAX_LIGHT_HANDLE];

int cur_paramlist_allocated = 0;
int cur_paramlist_size = 0;
RtToken *cur_paramlist_tokens = NULL;
RtPointer *cur_paramlist_args = NULL;
RtInt *cur_paramlist_sizes = NULL;

#define CPS cur_paramlist_size
#define CPT cur_paramlist_tokens
#define CPA cur_paramlist_args
#define CPSZ cur_paramlist_sizes

typedef struct RIB_array {
	int element_size;
	int allocated;
	int nelems;
	RtVoid *array;
} RIB_array;

RIB_array *cur_array = NULL;

#define NA(r) ((RtFloat *) r->array)
#define SA(r) ((const char **) r->array)

void AddArrayElement( void *elem ) {
	if (cur_array->nelems >= cur_array->allocated) {
		cur_array->allocated = 2*cur_array->allocated + 1;
		cur_array->array = realloc( cur_array->array,
			cur_array->allocated*cur_array->element_size );
	}
	char *next = ((char *)cur_array->array) + cur_array->nelems *
		cur_array->element_size;
	memcpy( next, elem, cur_array->element_size );
	cur_array->nelems++;
}

RIB_array *ArrayDup( RIB_array *ra )
{
	RIB_array *ret = new RIB_array;
	ret->element_size = ra->element_size;
	ret->allocated = ra->allocated;
	ret->nelems = ra->nelems;
	ret->array = new char[ra->nelems * ra->element_size];
	memcpy( ret->array, ra->array, ra->nelems * ra->element_size );
	return ret;
}

void ArrayFree( RIB_array *ra )
{
	delete [] ((char *) ra->array);
	delete ra;
}

static RtFloat * FindBasis( const char *str )
{
	/*
	if (!strcmp( str, "bezier" )) return (RtFloat *) RiBezierBasis;
	else if (!strcmp( str, "b-spline" )) return (RtFloat *) RiBSplineBasis;
	else if (!strcmp( str, "catmull-rom" )) return (RtFloat *) RiCatmullRomBasis;
	else if (!strcmp( str, "hermite" )) return (RtFloat *) RiHermiteBasis;
	else if (!strcmp( str, "power" )) return (RtFloat *) RiPowerBasis;
	else ParseError( "Unknown basis: %s", str );
	*/

	Warning("Named bases aren't supported yet...");

	return NULL;
}
static bool VerifyArrayLength( RIB_array *arr, RtInt required,
	const char *command ) {
	if (arr->nelems != required) {
		ParseError( "%s requires a(n) %d element array!", command, required);
		return false;
	}
	return true;
}

static RtInt *MakeIntArray( RIB_array *arr )
{
	RtInt *ret = new RtInt[arr->nelems];
	for (int i = 0 ; i < arr->nelems ; i++)
		ret[i] = RtInt(NA(arr)[i]);
	return ret;
}

static RtFilterFunc FindFilterFunc( const char *name )
{
	if (!strcmp( name, "box" ))
		return RiBoxFilter;
	else if (!strcmp( name, "triangle" ))
		return RiTriangleFilter;
	else if (!strcmp( name, "catmull-rom" ))
		return RiCatmullRomFilter;
	else if (!strcmp( name, "sinc" ))
		return RiSincFilter;
	else if (!strcmp( name, "gaussian" ))
		return RiGaussianFilter;
	else
		ParseError( "Unknown filter function :%s", name );
	return RtFilterFunc(NULL);
}

#line 133 "ribparse.y"
#ifndef YYSTYPE
typedef union {
char string[1024];
RtFloat num;
RIB_array *ribarray;
} yystype;
# define YYSTYPE yystype
# define YYSTYPE_IS_TRIVIAL 1
#endif
#ifndef YYDEBUG
# define YYDEBUG 1
#endif



#define	YYFINAL		421
#define	YYFLAG		-32768
#define	YYNTBASE	102

/* YYTRANSLATE(YYLEX) -- Bison token number corresponding to YYLEX. */
#define YYTRANSLATE(x) ((unsigned)(x) <= 355 ? yytranslate[x] : 123)

/* YYTRANSLATE[YYLEX] -- Bison token number corresponding to YYLEX. */
static const char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101
};

#if YYDEBUG
static const short yyprhs[] =
{
       0,     0,     2,     3,     4,     5,     7,     9,    11,    13,
      18,    21,    24,    26,    29,    31,    33,    38,    41,    44,
      46,    49,    52,    53,    56,    57,    60,    63,    65,    68,
      73,    77,    81,    83,    85,    91,    97,   103,   109,   117,
     120,   124,   129,   132,   136,   142,   146,   149,   152,   158,
     161,   168,   172,   176,   180,   185,   188,   196,   199,   205,
     208,   214,   218,   222,   228,   232,   236,   241,   244,   247,
     249,   253,   257,   261,   265,   275,   279,   281,   285,   289,
     293,   298,   308,   322,   330,   335,   345,   351,   354,   357,
     359,   372,   375,   377,   380,   385,   388,   392,   395,   402,
     406,   410,   418,   421,   426,   430,   433,   439,   444,   447,
     451,   458,   463,   466,   468,   474,   479,   485,   488,   491,
     494,   498,   501,   510,   513,   516,   518,   525,   529,   533,
     543,   546,   554,   558,   561,   563,   565,   570,   581,   583
};
static const short yyrhs[] =
{
     121,     0,     0,     0,     0,   107,     0,   112,     0,   108,
       0,   109,     0,   103,     6,   110,     7,     0,   103,   111,
       0,   110,   111,     0,   111,     0,   104,     3,     0,   113,
       0,   114,     0,   103,     6,   115,     7,     0,   103,   116,
       0,   115,   116,     0,   116,     0,   105,     5,     0,   118,
     119,     0,     0,   120,   119,     0,     0,     3,   106,     0,
     121,   122,     0,   122,     0,    98,     5,     0,     9,     3,
       5,   117,     0,    10,     3,   117,     0,    11,     3,   117,
       0,    12,     0,    13,     0,    14,     3,     5,     3,     5,
       0,    14,     3,     5,   113,     5,     0,    14,   113,     5,
       3,     5,     0,    14,   113,     5,   113,     5,     0,    15,
       5,     5,     5,     5,     5,     5,     0,    15,   113,     0,
      16,     5,     5,     0,    17,     5,     5,     5,     0,    17,
     113,     0,    18,   113,   113,     0,    20,     5,     5,     5,
     117,     0,    20,   113,   117,     0,    19,   112,     0,    21,
       3,     0,    22,     5,     5,     5,     5,     0,    22,   113,
       0,    23,     5,     5,     5,     5,   117,     0,    23,   113,
     117,     0,    24,     3,     3,     0,    25,     3,   117,     0,
      26,     5,     5,     5,     0,    26,     8,     0,    27,     5,
       5,     5,     5,     5,     5,     0,    27,   113,     0,    28,
       5,     5,     5,     5,     0,    28,   113,     0,    29,     5,
       5,     5,   117,     0,    29,   113,   117,     0,    30,     3,
     117,     0,    31,     3,     3,     3,   117,     0,    32,     5,
       5,     0,    33,     3,   117,     0,    34,     5,     5,     5,
       0,    35,     5,     0,    36,     5,     0,    37,     0,    38,
     112,   117,     0,    39,     3,     5,     0,    40,     3,   117,
       0,    41,     3,   117,     0,    42,     5,     5,     5,     5,
       5,     5,     5,   117,     0,    42,   113,   117,     0,    43,
       0,    44,     5,     5,     0,    45,     3,   117,     0,    46,
       3,   117,     0,    47,     3,     5,   117,     0,    48,     3,
       3,     3,     3,     3,     5,     5,   117,     0,    49,     3,
       3,     3,     3,     3,     3,     3,     5,     3,     5,     5,
     117,     0,    50,     3,     3,     3,     5,     5,   117,     0,
      51,     3,     3,   117,     0,    52,     3,     3,     3,     3,
       3,     5,     5,   117,     0,    53,     5,     5,   113,   117,
       0,    54,     5,     0,    55,   112,     0,    56,     0,    57,
       5,     5,   113,     5,     5,     5,     5,   113,     5,     5,
     117,     0,    58,     5,     0,    59,     0,    60,     5,     0,
      61,     5,     5,     5,     0,    61,   113,     0,    62,     3,
     117,     0,    63,     3,     0,    64,     5,     5,     5,     5,
     117,     0,    64,   113,   117,     0,    65,     3,   117,     0,
      66,     3,     5,     3,     5,     3,   117,     0,    67,     5,
       0,    68,     3,     5,     5,     0,    69,     5,     5,     0,
      70,     5,     0,    71,   112,   112,   112,   117,     0,    72,
     112,   112,   117,     0,    73,   117,     0,    74,     3,   117,
       0,    75,     3,     5,     5,     5,     5,     0,    76,     5,
       5,   117,     0,    77,     5,     0,    78,     0,    79,     5,
       5,     5,     5,     0,    80,     5,     5,     5,     0,    81,
       5,     5,     5,     5,     0,    81,   113,     0,    82,     3,
       0,    83,     5,     0,    84,     5,     5,     0,    85,     5,
       0,    86,     5,     5,     5,     5,     5,     5,     5,     0,
      86,   113,     0,    87,     3,     0,    88,     0,    89,     5,
       5,     5,     5,   117,     0,    89,   113,   117,     0,    90,
       3,   117,     0,    91,     5,     5,     5,     5,     5,     5,
       5,     5,     0,    91,   113,     0,    92,     5,     5,     5,
       5,     5,   117,     0,    92,   113,   117,     0,    93,   113,
       0,    94,     0,    95,     0,    96,     5,     5,     5,     0,
      97,   112,   112,   112,   112,   112,   112,   112,   112,   112,
       0,    99,     0,   100,     0
};

#endif

#if YYDEBUG
/* YYRLINE[YYN] -- source line where rule number YYN was defined. */
static const short yyrline[] =
{
       0,   169,   171,   180,   185,   190,   194,   199,   203,   208,
     212,   214,   215,   217,   223,   227,   232,   236,   238,   239,
     241,   247,   249,   254,   255,   257,   273,   274,   276,   277,
     285,   289,   293,   297,   301,   307,   315,   323,   330,   337,
     343,   347,   353,   359,   374,   378,   383,   389,   393,   397,
     403,   407,   413,   417,   421,   425,   429,   436,   442,   446,
     452,   456,   462,   466,   470,   474,   478,   482,   486,   490,
     494,   501,   505,   509,   513,   520,   530,   534,   547,   551,
     555,   563,   568,   574,   579,   583,   588,   592,   596,   601,
     605,   612,   616,   620,   624,   630,   636,   640,   644,   648,
     654,   658,   662,   666,   671,   675,   679,   696,   716,   738,
     742,   746,   750,   754,   758,   762,   766,   770,   776,   780,
     784,   788,   792,   796,   803,   807,   811,   815,   821,   825,
     830,   837,   841,   848,   854,   858,   862,   866,   889,   893
};
#endif


#if (YYDEBUG) || defined YYERROR_VERBOSE

/* YYTNAME[TOKEN_NUM] -- String name of the token TOKEN_NUM. */
static const char *const yytname[] =
{
  "$", "error", "$undefined.", "STRING", "ID", "NUM", "LBRACK", "RBRACK", 
  "DASH", "AREALIGHTSOURCE", "ATMOSPHERE", "ATTRIBUTE", "ATTRIBUTEBEGIN", 
  "ATTRIBUTEEND", "BASIS", "BOUND", "CLIPPING", "COLOR", "COLORSAMPLES", 
  "CONCATTRANSFORM", "CONE", "COORDINATESYSTEM", "CROPWINDOW", "CYLINDER", 
  "DECLARE", "DEFORMATION", "DEPTHOFFIELD", "DETAIL", "DETAILRANGE", 
  "DISK", "DISPLACEMENT", "DISPLAY", "EXPOSURE", "EXTERIOR", "FORMAT", 
  "FRAMEASPECTRATIO", "FRAMEBEGIN", "FRAMEEND", "GENERALPOLYGON", 
  "GEOMETRICAPPROXIMATION", "GEOMETRY", "HIDER", "HYPERBOLOID", 
  "IDENTITY", "ILLUMINATE", "IMAGER", "INTERIOR", "LIGHTSOURCE", 
  "MAKEBUMP", "MAKECUBEFACEENVIRONMENT", "MAKELATLONGENVIRONMENT", 
  "MAKESHADOW", "MAKETEXTURE", "MARTINIGLASSCONTOUR", "MATTE", 
  "MOTIONBEGIN", "MOTIONEND", "NUPATCH", "OBJECTBEGIN", "OBJECTEND", 
  "OBJECTINSTANCE", "OPACITY", "OPTION", "ORIENTATION", "PARABOLOID", 
  "PATCH", "PATCHMESH", "PERSPECTIVE", "PIXELFILTER", "PIXELSAMPLES", 
  "PIXELVARIANCE", "POINTSGENERALPOLYGONS", "POINTSPOLYGONS", "POLYGON", 
  "PROJECTION", "QUANTIZE", "RECTANGLE", "RELATIVEDETAIL", 
  "REVERSEORIENTATION", "ROTATE", "SCALE", "SCREENWINDOW", 
  "SHADINGINTERPOLATION", "SHADINGRATE", "SHUTTER", "SIDES", "SKEW", 
  "SOLIDBEGIN", "SOLIDEND", "SPHERE", "SURFACE", "TEXTURECOORDINATES", 
  "TORUS", "TRANSFORM", "TRANSFORMBEGIN", "TRANSFORMEND", "TRANSLATE", 
  "TRIMCURVE", "VERSION", "WORLDBEGIN", "WORLDEND", "HIGH_PRECEDENCE", 
  "start", "array_init", "string_array_init", "num_array_init", "array", 
  "string_array", "real_string_array", "single_element_string_array", 
  "string_list", "string_list_entry", "num_array", "real_num_array", 
  "single_element_num_array", "num_list", "num_list_entry", "paramlist", 
  "paramlist_init", "paramlist_contents", "paramlist_entry", 
  "ri_stmt_list", "ri_stmt", 0
};
#endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives. */
static const short yyr1[] =
{
       0,   102,   103,   104,   105,   106,   106,   107,   107,   108,
     109,   110,   110,   111,   112,   112,   113,   114,   115,   115,
     116,   117,   118,   119,   119,   120,   121,   121,   122,   122,
     122,   122,   122,   122,   122,   122,   122,   122,   122,   122,
     122,   122,   122,   122,   122,   122,   122,   122,   122,   122,
     122,   122,   122,   122,   122,   122,   122,   122,   122,   122,
     122,   122,   122,   122,   122,   122,   122,   122,   122,   122,
     122,   122,   122,   122,   122,   122,   122,   122,   122,   122,
     122,   122,   122,   122,   122,   122,   122,   122,   122,   122,
     122,   122,   122,   122,   122,   122,   122,   122,   122,   122,
     122,   122,   122,   122,   122,   122,   122,   122,   122,   122,
     122,   122,   122,   122,   122,   122,   122,   122,   122,   122,
     122,   122,   122,   122,   122,   122,   122,   122,   122,   122,
     122,   122,   122,   122,   122,   122,   122,   122,   122,   122
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN. */
static const short yyr2[] =
{
       0,     1,     0,     0,     0,     1,     1,     1,     1,     4,
       2,     2,     1,     2,     1,     1,     4,     2,     2,     1,
       2,     2,     0,     2,     0,     2,     2,     1,     2,     4,
       3,     3,     1,     1,     5,     5,     5,     5,     7,     2,
       3,     4,     2,     3,     5,     3,     2,     2,     5,     2,
       6,     3,     3,     3,     4,     2,     7,     2,     5,     2,
       5,     3,     3,     5,     3,     3,     4,     2,     2,     1,
       3,     3,     3,     3,     9,     3,     1,     3,     3,     3,
       4,     9,    13,     7,     4,     9,     5,     2,     2,     1,
      12,     2,     1,     2,     4,     2,     3,     2,     6,     3,
       3,     7,     2,     4,     3,     2,     5,     4,     2,     3,
       6,     4,     2,     1,     5,     4,     5,     2,     2,     2,
       3,     2,     8,     2,     2,     1,     6,     3,     3,     9,
       2,     7,     3,     2,     1,     1,     4,    10,     1,     1
};

/* YYDEFACT[S] -- default rule to reduce with in state S when YYTABLE
   doesn't specify something else to do.  Zero means the default is an
   error. */
static const short yydefact[] =
{
       0,     0,     0,     0,    32,    33,     2,     2,     0,     2,
       2,     2,     2,     0,     2,     2,     0,     0,     0,     2,
       2,     2,     0,     0,     0,     0,     0,     0,     0,    69,
       2,     0,     0,     0,     2,    76,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     2,    89,     0,
       0,    92,     0,     2,     0,     0,     2,     0,     0,     0,
       0,     0,     0,     2,     2,    22,     0,     0,     0,     0,
     113,     0,     0,     2,     0,     0,     0,     0,     2,     0,
     125,     2,     0,     2,     2,     2,   134,   135,     0,     2,
       0,   138,   139,     1,    27,     0,    22,    22,     0,     0,
       0,     0,    39,     0,     0,    42,     2,     4,    46,    14,
      15,     0,    22,    47,     0,    49,     0,    22,     0,    22,
       0,    55,     0,    57,     0,    59,     0,    22,    22,     0,
       0,    22,     0,    67,    68,    22,     0,    22,    22,     0,
      22,     0,    22,    22,     0,     0,     0,     0,     0,     0,
       0,    87,    88,     0,    91,    93,     0,    95,    22,    97,
       0,    22,    22,     0,   102,     0,     0,   105,     2,     2,
     108,    24,    22,     0,     0,   112,     0,     0,     0,   117,
     118,   119,     0,   121,     0,   123,   124,     0,    22,    22,
       0,   130,     0,    22,   133,     0,     2,    28,    26,    22,
      30,    31,     2,     4,     2,     0,    40,     0,    43,     0,
      17,     0,    45,     0,     0,    51,    52,    53,     0,     0,
       0,     0,    61,    62,     0,    64,    65,     0,    70,    71,
      72,    73,     0,    75,    77,    78,    79,    22,     0,     0,
       0,    22,     0,     2,     2,     0,    96,     0,    99,   100,
       0,     0,   104,     2,    22,     2,    21,    24,   109,     0,
      22,     0,     0,     0,   120,     0,     0,   127,   128,     0,
       0,   132,     0,     2,    29,     0,     0,     4,    19,     0,
       0,     0,    41,    20,    22,     0,     0,    54,     0,     0,
      22,    22,    66,     0,    80,     0,     0,     0,    84,     0,
      22,     0,    94,     0,     0,   103,    22,   107,     3,    25,
       5,     7,     8,     6,    23,     0,   111,     0,   115,     0,
       0,     0,     0,     0,   136,     2,    34,    35,    16,    18,
      36,    37,     0,    44,    48,    22,     0,    58,    60,    63,
       0,     0,     0,     0,     0,    86,     0,    22,     0,   106,
       3,     0,    10,     0,   114,   116,     0,    22,     0,     0,
       2,     0,    50,     0,     0,     0,     0,    22,     0,     0,
      98,    22,     3,    12,    13,   110,     0,   126,     0,    22,
       2,    38,    56,     0,     0,     0,    83,     0,     0,   101,
       9,    11,     0,     0,   131,     2,    22,    22,     0,    22,
       2,   122,     0,     2,    74,    81,     0,    85,     0,   129,
       2,     0,     0,   137,     0,    22,    22,    90,    82,     0,
       0,     0
};

static const short yydefgoto[] =
{
     419,    99,   351,   209,   309,   310,   311,   312,   372,   352,
     108,   109,   110,   277,   210,   170,   171,   256,   257,    93,
      94
};

static const short yypact[] =
{
     495,     0,     8,    11,-32768,-32768,    13,    15,    16,    22,
  -32768,-32768,    23,    26,    25,    27,    28,    30,    -3,    29,
      33,    34,    32,    37,    38,    41,    40,    42,    43,-32768,
  -32768,    46,    47,    48,    49,-32768,    50,    54,    55,    57,
      58,    59,    60,    61,    62,    63,    64,-32768,-32768,    65,
      66,-32768,    67,    68,    71,    74,    75,    76,    79,    78,
      82,    84,    85,-32768,-32768,-32768,    88,    89,    90,    91,
  -32768,    92,    93,    94,    97,    96,    98,    99,   100,   103,
  -32768,   102,   105,   106,   107,-32768,-32768,-32768,   108,-32768,
     109,-32768,-32768,   495,-32768,   110,-32768,-32768,   111,   104,
     112,   113,-32768,   114,   115,-32768,-32768,   104,-32768,-32768,
  -32768,   116,-32768,-32768,   117,-32768,   118,-32768,   121,-32768,
     120,-32768,   122,-32768,   123,-32768,   124,-32768,-32768,   127,
     126,-32768,   128,-32768,-32768,-32768,   129,-32768,-32768,   130,
  -32768,   131,-32768,-32768,   132,   135,   136,   137,   138,   139,
     140,-32768,-32768,   144,-32768,-32768,   145,-32768,-32768,-32768,
     146,-32768,-32768,   147,-32768,   148,   149,-32768,-32768,-32768,
  -32768,   141,-32768,   150,   151,-32768,   154,   155,   156,-32768,
  -32768,-32768,   157,-32768,   158,-32768,-32768,   159,-32768,-32768,
     160,-32768,   161,-32768,-32768,   162,-32768,-32768,-32768,-32768,
  -32768,-32768,   165,-32768,   166,   167,-32768,   168,-32768,   170,
  -32768,   171,-32768,   172,   173,-32768,-32768,-32768,   174,   175,
     176,   177,-32768,-32768,   183,-32768,-32768,   182,-32768,-32768,
  -32768,-32768,   184,-32768,-32768,-32768,-32768,-32768,   185,   187,
     188,-32768,   189,-32768,-32768,   190,-32768,   191,-32768,-32768,
     194,   193,-32768,-32768,-32768,-32768,-32768,   141,-32768,   195,
  -32768,   196,   197,   198,-32768,   203,   204,-32768,-32768,   205,
     206,-32768,   207,-32768,-32768,   208,   211,    39,-32768,   212,
     214,   215,-32768,-32768,-32768,   216,   218,-32768,   221,   223,
  -32768,-32768,-32768,   227,-32768,   231,   232,   233,-32768,   234,
  -32768,   235,-32768,   236,   238,-32768,-32768,-32768,     1,-32768,
  -32768,-32768,-32768,-32768,-32768,   245,-32768,   247,-32768,   248,
     249,   250,   251,   252,-32768,-32768,-32768,-32768,-32768,-32768,
  -32768,-32768,   253,-32768,-32768,-32768,   255,-32768,-32768,-32768,
     256,   260,   261,   262,   263,-32768,   264,-32768,   265,-32768,
     266,   267,-32768,   268,-32768,-32768,   269,-32768,   272,   273,
  -32768,   274,-32768,   276,   277,   278,   281,-32768,   280,   282,
  -32768,-32768,    86,-32768,-32768,-32768,   283,-32768,   284,-32768,
  -32768,-32768,-32768,   285,   286,   289,-32768,   288,   290,-32768,
  -32768,-32768,   291,   292,-32768,-32768,-32768,-32768,   293,-32768,
  -32768,-32768,   294,-32768,-32768,-32768,   297,-32768,   296,-32768,
  -32768,   299,   300,-32768,   301,-32768,-32768,-32768,-32768,   143,
     239,-32768
};

static const short yypgoto[] =
{
  -32768,   -11,-32768,-32768,-32768,-32768,-32768,-32768,-32768,  -346,
     -22,     3,-32768,-32768,  -202,    87,-32768,  -191,-32768,-32768,
       9
};


#define	YYLAST		595


static const short yytable[] =
{
     107,   278,   120,    95,   373,   121,    -4,   350,   135,   100,
     102,    96,   105,   106,    97,   112,    98,   115,   117,   107,
     101,   103,   123,   125,   127,   152,   391,   104,   111,   113,
     114,   118,   116,   119,   122,   128,   107,   140,   124,   126,
     129,   168,   169,   130,   131,   132,   328,   133,   134,   136,
     137,   138,   107,   107,   139,   141,   157,   142,   143,   161,
     144,   145,   146,   147,   148,   149,   314,   196,   150,   151,
     153,   154,   155,   156,   158,   329,   179,   159,   107,   162,
     160,   185,   163,   164,   188,   165,   191,   193,   194,   166,
     167,   172,   173,   390,     0,   174,   175,   176,   177,   178,
     180,   181,   198,   182,   183,   184,   186,   187,   189,   208,
     203,   190,   192,   195,   197,   199,   202,   204,   205,   206,
     207,   211,   213,   214,   216,   218,     0,   219,   220,   221,
     224,   225,     0,   227,   229,   232,   234,   237,   238,   239,
     240,   241,   242,   420,   255,   243,   253,   254,   278,   244,
     245,   247,   250,   251,   252,   259,   260,   107,   107,   261,
     262,   263,   264,   265,   266,   269,   270,   272,   275,   279,
       0,     0,   281,   282,   273,   283,   284,   285,   286,   287,
     288,   289,   290,   200,   201,   107,   291,   292,   295,   293,
     296,   297,   299,     0,     0,   302,   303,   304,   305,   212,
     315,   317,   318,   319,   215,   276,   217,   280,   320,   321,
     322,   323,   324,   326,   222,   223,   327,   330,   226,   331,
     332,   334,   228,   335,   230,   231,   336,   233,   337,   235,
     236,   306,   340,   313,   341,   342,     0,   344,   343,   421,
     346,   347,   107,   348,   308,   246,   300,   301,   248,   249,
     353,   325,   354,   355,   356,   357,   358,   359,   361,   258,
     363,   364,   107,   365,   366,     0,   368,   367,   371,   369,
     374,    -4,     0,   375,   376,   267,   268,   378,   379,   381,
     271,   382,   383,   384,   385,   387,   274,   388,   392,   393,
     396,   397,   398,   399,     0,   400,   401,   402,   406,   409,
     411,   412,     0,   360,   414,   415,   416,     0,     0,     0,
       0,     0,     0,     0,   107,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   294,     0,     0,     0,   298,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   380,     0,
       0,   307,     0,     0,     0,     0,     0,   316,     0,   107,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   107,
       0,   333,     0,   403,     0,     0,     0,   338,   339,     0,
       0,   410,     0,     0,   107,     0,     0,   345,   413,     0,
       0,     0,   107,   349,     0,     0,     0,     0,     0,   107,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   362,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   370,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   377,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   386,     0,     0,     0,   389,     0,
       0,     0,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   404,   405,     0,   407,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   417,   418,     1,     2,     3,     4,     5,     6,
       7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92
};

static const short yycheck[] =
{
      11,   203,     5,     3,   350,     8,     5,     6,    30,     6,
       7,     3,     9,    10,     3,    12,     3,    14,    15,    30,
       5,     5,    19,    20,    21,    47,   372,     5,     5,     3,
       5,     3,     5,     3,     5,     3,    47,    34,     5,     5,
       3,    63,    64,     5,     3,     5,     7,     5,     5,     3,
       3,     3,    63,    64,     5,     5,    53,     3,     3,    56,
       3,     3,     3,     3,     3,     3,   257,    89,     5,     5,
       5,     5,     5,     5,     3,   277,    73,     3,    89,     3,
       5,    78,     3,     5,    81,     3,    83,    84,    85,     5,
       5,     3,     3,     7,    -1,     5,     5,     5,     5,     5,
       3,     5,    93,     5,     5,     5,     3,     5,     3,   106,
       6,     5,     5,     5,     5,     5,     5,     5,     5,     5,
       5,     5,     5,     5,     3,     5,    -1,     5,     5,     5,
       3,     5,    -1,     5,     5,     5,     5,     5,     3,     3,
       3,     3,     3,     0,     3,     5,   168,   169,   350,     5,
       5,     5,     5,     5,     5,     5,     5,   168,   169,     5,
       5,     5,     5,     5,     5,     5,     5,     5,     3,     3,
      -1,    -1,     5,     5,   196,     5,     5,     5,     5,     5,
       5,     5,     5,    96,    97,   196,     3,     5,     3,     5,
       3,     3,     3,    -1,    -1,     5,     5,     3,     5,   112,
       5,     5,     5,     5,   117,   202,   119,   204,     5,     5,
       5,     5,     5,     5,   127,   128,     5,     5,   131,     5,
       5,     5,   135,     5,   137,   138,     5,   140,     5,   142,
     143,   253,     5,   255,     3,     3,    -1,     3,     5,     0,
       5,     5,   253,     5,   255,   158,   243,   244,   161,   162,
       5,   273,     5,     5,     5,     5,     5,     5,     5,   172,
       5,     5,   273,     3,     3,    -1,     3,     5,     3,     5,
       3,     5,    -1,     5,     5,   188,   189,     5,     5,     5,
     193,     5,     5,     5,     3,     5,   199,     5,     5,     5,
       5,     5,     3,     5,    -1,     5,     5,     5,     5,     5,
       3,     5,    -1,   325,     5,     5,     5,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   325,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   360,    -1,
      -1,   254,    -1,    -1,    -1,    -1,    -1,   260,    -1,   360,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   380,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   380,
      -1,   284,    -1,   395,    -1,    -1,    -1,   290,   291,    -1,
      -1,   403,    -1,    -1,   395,    -1,    -1,   300,   410,    -1,
      -1,    -1,   403,   306,    -1,    -1,    -1,    -1,    -1,   410,
      -1,    -1,    -1,   400,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   335,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   357,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   367,    -1,    -1,    -1,   371,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   379,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   396,   397,    -1,   399,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   415,   416,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/bison/bison.simple"

/* Skeleton output parser for bison,

   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software
   Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser when
   the %semantic_parser declaration is not specified in the grammar.
   It was written by Richard Stallman by simplifying the hairy parser
   used when %semantic_parser is specified.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

#if ! defined (yyoverflow) || defined (YYERROR_VERBOSE)

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || defined (YYERROR_VERBOSE) */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYLTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
# if YYLSP_NEEDED
  YYLTYPE yyls;
# endif
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAX (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# if YYLSP_NEEDED
#  define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAX)
# else
#  define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAX)
# endif

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAX;	\
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif


#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");			\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).

   When YYLLOC_DEFAULT is run, CURRENT is set the location of the
   first token.  By default, to implement support for ranges, extend
   its range to the last symbol.  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)       	\
   Current.last_line   = Rhs[N].last_line;	\
   Current.last_column = Rhs[N].last_column;
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#if YYPURE
# if YYLSP_NEEDED
#  ifdef YYLEX_PARAM
#   define YYLEX		yylex (&yylval, &yylloc, YYLEX_PARAM)
#  else
#   define YYLEX		yylex (&yylval, &yylloc)
#  endif
# else /* !YYLSP_NEEDED */
#  ifdef YYLEX_PARAM
#   define YYLEX		yylex (&yylval, YYLEX_PARAM)
#  else
#   define YYLEX		yylex (&yylval)
#  endif
# endif /* !YYLSP_NEEDED */
#else /* !YYPURE */
# define YYLEX			yylex ()
#endif /* !YYPURE */


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)
/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
#endif /* !YYDEBUG */

/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif

#ifdef YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif
#endif

#line 315 "/usr/share/bison/bison.simple"


/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
#  define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#  define YYPARSE_PARAM_DECL
# else
#  define YYPARSE_PARAM_ARG YYPARSE_PARAM
#  define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
# endif
#else /* !YYPARSE_PARAM */
# define YYPARSE_PARAM_ARG
# define YYPARSE_PARAM_DECL
#endif /* !YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
# ifdef YYPARSE_PARAM
int yyparse (void *);
# else
int yyparse (void);
# endif
#endif

/* YY_DECL_VARIABLES -- depending whether we use a pure parser,
   variables are global, or local to YYPARSE.  */

#define YY_DECL_NON_LSP_VARIABLES			\
/* The lookahead symbol.  */				\
int yychar;						\
							\
/* The semantic value of the lookahead symbol. */	\
YYSTYPE yylval;						\
							\
/* Number of parse errors so far.  */			\
int yynerrs;

#if YYLSP_NEEDED
# define YY_DECL_VARIABLES			\
YY_DECL_NON_LSP_VARIABLES			\
						\
/* Location data for the lookahead symbol.  */	\
YYLTYPE yylloc;
#else
# define YY_DECL_VARIABLES			\
YY_DECL_NON_LSP_VARIABLES
#endif


/* If nonreentrant, generate the variables here. */

#if !YYPURE
YY_DECL_VARIABLES
#endif  /* !YYPURE */

int
yyparse (YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  /* If reentrant, generate the variables here. */
#if YYPURE
  YY_DECL_VARIABLES
#endif  /* !YYPURE */

  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yychar1 = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack. */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;

#if YYLSP_NEEDED
  /* The location stack.  */
  YYLTYPE yylsa[YYINITDEPTH];
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;
#endif

#if YYLSP_NEEDED
# define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
# define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  YYSIZE_T yystacksize = YYINITDEPTH;


  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
#if YYLSP_NEEDED
  YYLTYPE yyloc;
#endif

  /* When reducing, the number of symbols on the RHS of the reduced
     rule. */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;
#if YYLSP_NEEDED
  yylsp = yyls;
#endif
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  */
# if YYLSP_NEEDED
	YYLTYPE *yyls1 = yyls;
	/* This used to be a conditional around just the two extra args,
	   but that might be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yyls1, yysize * sizeof (*yylsp),
		    &yystacksize);
	yyls = yyls1;
# else
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yystacksize);
# endif
	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);
# if YYLSP_NEEDED
	YYSTACK_RELOCATE (yyls);
# endif
# undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
#if YYLSP_NEEDED
      yylsp = yyls + yysize - 1;
#endif

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yychar1 = YYTRANSLATE (yychar);

#if YYDEBUG
     /* We have to keep this `#if YYDEBUG', since we use variables
	which are defined only if `YYDEBUG' is set.  */
      if (yydebug)
	{
	  YYFPRINTF (stderr, "Next token is %d (%s",
		     yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise
	     meaning of a token, for further debugging info.  */
# ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
# endif
	  YYFPRINTF (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %d (%s), ",
	      yychar, yytname[yychar1]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#if YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to the semantic value of
     the lookahead token.  This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

#if YYLSP_NEEDED
  /* Similarly for the default location.  Let the user run additional
     commands if for instance locations are ranges.  */
  yyloc = yylsp[1-yylen];
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
#endif

#if YYDEBUG
  /* We have to keep this `#if YYDEBUG', since we use variables which
     are defined only if `YYDEBUG' is set.  */
  if (yydebug)
    {
      int yyi;

      YYFPRINTF (stderr, "Reducing via rule %d (line %d), ",
		 yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (yyi = yyprhs[yyn]; yyrhs[yyi] > 0; yyi++)
	YYFPRINTF (stderr, "%s ", yytname[yyrhs[yyi]]);
      YYFPRINTF (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif

  switch (yyn) {

case 2:
#line 172 "ribparse.y"
{
	if (cur_array) ArrayFree( cur_array );
	cur_array = new RIB_array;
	cur_array->allocated = 0;
	cur_array->nelems = 0;
	cur_array->array = NULL;
;
    break;}
case 3:
#line 181 "ribparse.y"
{
	cur_array->element_size = sizeof( const char * );
;
    break;}
case 4:
#line 186 "ribparse.y"
{
	cur_array->element_size = sizeof( RtFloat );
;
    break;}
case 5:
#line 191 "ribparse.y"
{
	yyval.ribarray = yyvsp[0].ribarray;
;
    break;}
case 6:
#line 195 "ribparse.y"
{
	yyval.ribarray = yyvsp[0].ribarray;
;
    break;}
case 7:
#line 200 "ribparse.y"
{
	yyval.ribarray = yyvsp[0].ribarray;
;
    break;}
case 8:
#line 204 "ribparse.y"
{
	yyval.ribarray = ArrayDup(cur_array);
;
    break;}
case 9:
#line 209 "ribparse.y"
{
	yyval.ribarray = ArrayDup(cur_array);
;
    break;}
case 13:
#line 218 "ribparse.y"
{
	char *to_add = strdup(yyvsp[0].string);
	AddArrayElement( &to_add );
;
    break;}
case 14:
#line 224 "ribparse.y"
{
	yyval.ribarray = yyvsp[0].ribarray;
;
    break;}
case 15:
#line 228 "ribparse.y"
{
	yyval.ribarray = ArrayDup(cur_array);
;
    break;}
case 16:
#line 233 "ribparse.y"
{
	yyval.ribarray = ArrayDup(cur_array);
;
    break;}
case 20:
#line 242 "ribparse.y"
{
	RtFloat to_add = yyvsp[0].num;
	AddArrayElement( &to_add );
;
    break;}
case 22:
#line 250 "ribparse.y"
{
	cur_paramlist_size = 0;
;
    break;}
case 25:
#line 258 "ribparse.y"
{
	RtPointer arg = new char[ yyvsp[0].ribarray->nelems * yyvsp[0].ribarray->element_size ];
	memcpy( arg, yyvsp[0].ribarray->array, yyvsp[0].ribarray->nelems * yyvsp[0].ribarray->element_size );
	if (cur_paramlist_size >= cur_paramlist_allocated) {
		cur_paramlist_allocated = 2*cur_paramlist_allocated + 1;
		cur_paramlist_tokens = (RtToken *) realloc( cur_paramlist_tokens, cur_paramlist_allocated*sizeof(RtToken) );
		cur_paramlist_args = (RtPointer *) realloc( cur_paramlist_args, cur_paramlist_allocated*sizeof(RtPointer) );
		cur_paramlist_sizes = (RtInt *) realloc( cur_paramlist_sizes, cur_paramlist_allocated*sizeof(RtInt) );
	}
	cur_paramlist_tokens[cur_paramlist_size] = yyvsp[-1].string;
	cur_paramlist_sizes[cur_paramlist_size] = yyvsp[0].ribarray->nelems;
	cur_paramlist_args[cur_paramlist_size++] = arg;
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 28:
#line 276 "ribparse.y"
{ printf ("RIB Version: %f\n", yyvsp[0].num ); ;
    break;}
case 29:
#line 278 "ribparse.y"
{
    int num = (int)yyvsp[-1].num;
	if (num < 0 || num >= MAX_LIGHT_HANDLE)
		Error("Invalid light handle %d passed to AreaLightSource. Ignoring.", num);
	else
		lights[num] = RiAreaLightSourceV( yyvsp[-2].string, CPS, CPT, CPA );
;
    break;}
case 30:
#line 286 "ribparse.y"
{
	RiAtmosphereV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 31:
#line 290 "ribparse.y"
{
	RiAttributeV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 32:
#line 294 "ribparse.y"
{
	RiAttributeBegin();
;
    break;}
case 33:
#line 298 "ribparse.y"
{
	RiAttributeEnd();
;
    break;}
case 34:
#line 302 "ribparse.y"
{
	RtFloat * basis1 = FindBasis( yyvsp[-3].string );
	RtFloat * basis2 = FindBasis( yyvsp[-1].string );
	RiBasis( basis1, RtInt(yyvsp[-2].num), basis2, RtInt(yyvsp[0].num) );
;
    break;}
case 35:
#line 308 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[-1].ribarray, 16, "Basis" )) {
		RtFloat * basis1 = FindBasis( yyvsp[-3].string );
		RiBasis( basis1, RtInt(yyvsp[-2].num), (RtFloat *) yyvsp[-1].ribarray->array, RtInt(yyvsp[0].num) );
	}
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 36:
#line 316 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[-3].ribarray, 16, "Basis" )) {
		RtFloat * basis2 = FindBasis( yyvsp[-1].string );
		RiBasis( (RtFloat *) yyvsp[-3].ribarray->array, RtInt(yyvsp[-2].num), basis2, RtInt(yyvsp[0].num) );
	}
	ArrayFree( yyvsp[-3].ribarray );
;
    break;}
case 37:
#line 324 "ribparse.y"
{
	if (VerifyArrayLength(yyvsp[-3].ribarray, 16, "Basis") && VerifyArrayLength(yyvsp[-1].ribarray, 16, "Basis"))
		RiBasis( (RtFloat *) yyvsp[-3].ribarray->array, RtInt(yyvsp[-2].num), (RtFloat *) yyvsp[-1].ribarray->array, RtInt(yyvsp[0].num) );
	ArrayFree( yyvsp[-3].ribarray );
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 38:
#line 331 "ribparse.y"
{
	RtBound bound;
	bound[0] = yyvsp[-5].num; bound[1] = yyvsp[-4].num; bound[2] = yyvsp[-3].num;
	bound[3] = yyvsp[-2].num; bound[4] = yyvsp[-1].num; bound[5] = yyvsp[0].num;
	RiBound( bound );
;
    break;}
case 39:
#line 338 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 6, "Bound" ))
		RiBound( (RtFloat *) yyvsp[0].ribarray->array );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 40:
#line 344 "ribparse.y"
{
	RiClipping( yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 41:
#line 348 "ribparse.y"
{
	RtBound color;
	color[0] = yyvsp[-2].num; color[1] = yyvsp[-1].num; color[2] = yyvsp[0].num;
	RiColor( color );
;
    break;}
case 42:
#line 354 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 3, "Color" ));
		RiColor( (RtFloat *) yyvsp[0].ribarray->array );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 43:
#line 360 "ribparse.y"
{
	if (yyvsp[-1].ribarray->nelems != yyvsp[0].ribarray->nelems) {
		ParseError( "The two arrays should be the same size in ColorSamples" );
		goto noGoodColor;
	}
	if (yyvsp[-1].ribarray->nelems % 3 != 0) {
		ParseError( "The two arrays should be the multiples of 3 in ColorSamples" );
		goto noGoodColor;
	}
	RiColorSamples( yyvsp[-1].ribarray->nelems / 3, NA(yyvsp[-1].ribarray), NA(yyvsp[0].ribarray) );
noGoodColor:
	ArrayFree( yyvsp[-1].ribarray );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 44:
#line 375 "ribparse.y"
{
	RiConeV( yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 45:
#line 379 "ribparse.y"
{
	VerifyArrayLength( yyvsp[-1].ribarray, 3, "Cone" );
	RiConeV( NA(yyvsp[-1].ribarray)[0], NA(yyvsp[-1].ribarray)[1], NA(yyvsp[-1].ribarray)[2], CPS, CPT, CPA );
;
    break;}
case 46:
#line 384 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 16, "ConcatTransform" ));
		RiConcatTransform( (RtFloat *) yyvsp[0].ribarray->array );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 47:
#line 390 "ribparse.y"
{
	RiCoordinateSystem( yyvsp[0].string );
;
    break;}
case 48:
#line 394 "ribparse.y"
{
	RiCropWindow( yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 49:
#line 398 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 4, "CropWindow" ))
		RiCropWindow( NA(yyvsp[0].ribarray)[0], NA(yyvsp[0].ribarray)[1], NA(yyvsp[0].ribarray)[2], NA(yyvsp[0].ribarray)[3] );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 50:
#line 404 "ribparse.y"
{
	RiCylinderV( yyvsp[-4].num, yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 51:
#line 408 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[-1].ribarray, 4, "Cylinder" ))
		RiCylinderV( NA(yyvsp[-1].ribarray)[0], NA(yyvsp[-1].ribarray)[1], NA(yyvsp[-1].ribarray)[2], NA(yyvsp[-1].ribarray)[3], CPS, CPT, CPA );
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 52:
#line 414 "ribparse.y"
{
	RiDeclare( yyvsp[-1].string, yyvsp[0].string );
;
    break;}
case 53:
#line 418 "ribparse.y"
{
	RiDeformationV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 54:
#line 422 "ribparse.y"
{
	RiDepthOfField( yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 55:
#line 426 "ribparse.y"
{
	RiDepthOfField( RI_INFINITY, 0, 0 );
;
    break;}
case 56:
#line 430 "ribparse.y"
{
	RtBound bound;
	bound[0] = yyvsp[-5].num; bound[1] = yyvsp[-4].num; bound[2] = yyvsp[-3].num;
	bound[3] = yyvsp[-2].num; bound[4] = yyvsp[-1].num; bound[5] = yyvsp[0].num;
	RiDetail( bound );
;
    break;}
case 57:
#line 437 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 6, "Detail" ))
		RiDetail( (RtFloat *) yyvsp[0].ribarray->array );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 58:
#line 443 "ribparse.y"
{
	RiDetailRange( yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 59:
#line 447 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 4, "DetailRange" ))
		RiDetailRange( NA(yyvsp[0].ribarray)[0], NA(yyvsp[0].ribarray)[1], NA(yyvsp[0].ribarray)[2], NA(yyvsp[0].ribarray)[3] );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 60:
#line 453 "ribparse.y"
{
	RiDiskV( yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 61:
#line 457 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[-1].ribarray, 3, "Disk" ))
		RiDiskV( NA(yyvsp[-1].ribarray)[0], NA(yyvsp[-1].ribarray)[1], NA(yyvsp[-1].ribarray)[2], CPS, CPT, CPA );
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 62:
#line 463 "ribparse.y"
{
	RiDisplacementV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 63:
#line 467 "ribparse.y"
{
	RiDisplayV( yyvsp[-3].string, yyvsp[-2].string, yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 64:
#line 471 "ribparse.y"
{
	RiExposure( yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 65:
#line 475 "ribparse.y"
{
	RiExteriorV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 66:
#line 479 "ribparse.y"
{
	RiFormat( RtInt(yyvsp[-2].num), RtInt(yyvsp[-1].num), yyvsp[0].num );
;
    break;}
case 67:
#line 483 "ribparse.y"
{
	RiFrameAspectRatio( yyvsp[0].num );
;
    break;}
case 68:
#line 487 "ribparse.y"
{
	RiFrameBegin( RtInt(yyvsp[0].num) );
;
    break;}
case 69:
#line 491 "ribparse.y"
{
	RiFrameEnd();
;
    break;}
case 70:
#line 495 "ribparse.y"
{
	RtInt *verts = MakeIntArray( yyvsp[-1].ribarray );
	RiGeneralPolygonV( yyvsp[-1].ribarray->nelems, verts, CPS, CPT, CPA );
	delete [] verts;
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 71:
#line 502 "ribparse.y"
{
	RiGeometricApproximation( yyvsp[-1].string, yyvsp[0].num );
;
    break;}
case 72:
#line 506 "ribparse.y"
{
	RiGeometryV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 73:
#line 510 "ribparse.y"
{
	RiHiderV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 74:
#line 514 "ribparse.y"
{
	RtPoint point1, point2;
	point1[0] = yyvsp[-7].num; point1[1] = yyvsp[-6].num; point1[2] = yyvsp[-5].num;
	point2[0] = yyvsp[-4].num; point2[1] = yyvsp[-3].num; point2[2] = yyvsp[-2].num;
	RiHyperboloidV( point1, point2, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 75:
#line 521 "ribparse.y"
{
	RtBound point1, point2;
	if (VerifyArrayLength( yyvsp[-1].ribarray, 7, "Hyperboloid" )) {
		point1[0] = NA(yyvsp[-1].ribarray)[0]; point1[1] = NA(yyvsp[-1].ribarray)[1]; point1[2] = NA(yyvsp[-1].ribarray)[2];
		point2[0] = NA(yyvsp[-1].ribarray)[3]; point2[1] = NA(yyvsp[-1].ribarray)[4]; point2[2] = NA(yyvsp[-1].ribarray)[5];
		RiHyperboloidV( point1, point2, NA(yyvsp[-1].ribarray)[6], CPS, CPT, CPA );
	}
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 76:
#line 531 "ribparse.y"
{
	RiIdentity();
;
    break;}
case 77:
#line 535 "ribparse.y"
{
    int num = (int)yyvsp[-1].num;
	if (num < 0 || num >= MAX_LIGHT_HANDLE)
		Error("Invalid light handle %d passed to Illuminate. Ignoring.", num);
	else {
		RtLightHandle light = lights[num];
		if (light == (RtLightHandle)RI_NULL)
			ParseError( "Unknown light number: %d", num);
		else
			RiIlluminate( light, (RtBoolean) yyvsp[0].num );
	}
;
    break;}
case 78:
#line 548 "ribparse.y"
{
	RiImagerV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 79:
#line 552 "ribparse.y"
{
	RiInteriorV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 80:
#line 556 "ribparse.y"
{
    int num = (int)yyvsp[-1].num;
	if (num < 0 || num >= MAX_LIGHT_HANDLE)
		Error("Invalid light handle %d passed to LightSource. Ignoring.", num);
	else
		lights[num] = RiLightSourceV( yyvsp[-2].string, CPS, CPT, CPA );
;
    break;}
case 81:
#line 564 "ribparse.y"
{
	RtFilterFunc filterfunc = FindFilterFunc( yyvsp[-3].string );
	RiMakeBumpV( yyvsp[-7].string, yyvsp[-6].string, yyvsp[-5].string, yyvsp[-4].string, filterfunc, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 82:
#line 569 "ribparse.y"
{
	RtFilterFunc filterfunc = FindFilterFunc( yyvsp[-3].string );
	RiMakeCubeFaceEnvironmentV( yyvsp[-11].string, yyvsp[-10].string, yyvsp[-9].string, yyvsp[-8].string, yyvsp[-7].string, yyvsp[-6].string, yyvsp[-5].string, yyvsp[-4].num, filterfunc,
		yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 83:
#line 575 "ribparse.y"
{
	RtFilterFunc filterfunc = FindFilterFunc( yyvsp[-3].string );
	RiMakeLatLongEnvironmentV( yyvsp[-5].string, yyvsp[-4].string, filterfunc, yyvsp[-2].num, yyvsp[-2].num, CPS, CPT, CPA );
;
    break;}
case 84:
#line 580 "ribparse.y"
{
	RiMakeShadowV( yyvsp[-2].string, yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 85:
#line 584 "ribparse.y"
{
	RtFilterFunc filterfunc = FindFilterFunc( yyvsp[-3].string );
	RiMakeTextureV( yyvsp[-7].string, yyvsp[-6].string, yyvsp[-5].string, yyvsp[-4].string, filterfunc, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 86:
#line 589 "ribparse.y"
{
        RiMartiniGlassContourV( yyvsp[-3].num, RtInt(yyvsp[-2].num), NA(yyvsp[-1].ribarray), CPS, CPT, CPA );
;
    break;}
case 87:
#line 593 "ribparse.y"
{
	RiMatte( yyvsp[0].num != 0. );
;
    break;}
case 88:
#line 597 "ribparse.y"
{
	RiMotionBeginV( yyvsp[0].ribarray->nelems, NA(yyvsp[0].ribarray) );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 89:
#line 602 "ribparse.y"
{
	RiMotionEnd();
;
    break;}
case 90:
#line 606 "ribparse.y"
{
	RiNuPatchV( RtInt(yyvsp[-10].num), RtInt(yyvsp[-9].num), NA(yyvsp[-8].ribarray), yyvsp[-7].num, yyvsp[-6].num,
				RtInt(yyvsp[-5].num), RtInt(yyvsp[-4].num), NA(yyvsp[-3].ribarray), yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
	ArrayFree(yyvsp[-8].ribarray);
	ArrayFree(yyvsp[-3].ribarray);
;
    break;}
case 91:
#line 613 "ribparse.y"
{
	Warning( "Don't know how to parse ObjectInstance" );
;
    break;}
case 92:
#line 617 "ribparse.y"
{
	RiObjectEnd();
;
    break;}
case 93:
#line 621 "ribparse.y"
{
	Warning( "Don't know how to parse ObjectInstance" );
;
    break;}
case 94:
#line 625 "ribparse.y"
{
	RtColor color;
	color[0] = yyvsp[-2].num; color[1] = yyvsp[-1].num; color[2] = yyvsp[0].num;
	RiOpacity( color );
;
    break;}
case 95:
#line 631 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 3, "Opacity" ))
		RiOpacity( (RtFloat *) yyvsp[0].ribarray->array );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 96:
#line 637 "ribparse.y"
{
	RiOptionV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 97:
#line 641 "ribparse.y"
{
	RiOrientation( yyvsp[0].string );
;
    break;}
case 98:
#line 645 "ribparse.y"
{
	RiParaboloidV( yyvsp[-4].num, yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 99:
#line 649 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[-1].ribarray, 4, "Paraboloid" ))
		RiParaboloidV( NA(yyvsp[-1].ribarray)[0], NA(yyvsp[-1].ribarray)[1], NA(yyvsp[-1].ribarray)[2], NA(yyvsp[-1].ribarray)[3], CPS, CPT, CPA );
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 100:
#line 655 "ribparse.y"
{
	RiPatchV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 101:
#line 659 "ribparse.y"
{
	RiPatchMeshV( yyvsp[-5].string, RtInt(yyvsp[-4].num), yyvsp[-3].string, RtInt(yyvsp[-2].num), yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 102:
#line 663 "ribparse.y"
{
	RiPerspective( yyvsp[0].num );
;
    break;}
case 103:
#line 667 "ribparse.y"
{
	RtFilterFunc func = FindFilterFunc( yyvsp[-2].string );
	RiPixelFilter( func, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 104:
#line 672 "ribparse.y"
{
	RiPixelSamples( yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 105:
#line 676 "ribparse.y"
{
	RiPixelVariance( yyvsp[0].num );
;
    break;}
case 106:
#line 680 "ribparse.y"
{
	RtInt *nloops, *nvertices, *vertices;

	nloops = MakeIntArray( yyvsp[-3].ribarray );
	nvertices = MakeIntArray( yyvsp[-2].ribarray );
	vertices = MakeIntArray( yyvsp[-1].ribarray );

	RiPointsGeneralPolygonsV( yyvsp[-3].ribarray->nelems, nloops, nvertices, vertices, CPS, CPT, CPA );

	delete [] nloops;
	delete [] nvertices;
	delete [] vertices;
	ArrayFree( yyvsp[-3].ribarray );
	ArrayFree( yyvsp[-2].ribarray );
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 107:
#line 697 "ribparse.y"
{
	// Gotta convert these bad boys to arrays of integers.  that sucks.
	RtInt *nverts, *verts;

	nverts = MakeIntArray( yyvsp[-2].ribarray );
	verts = MakeIntArray( yyvsp[-1].ribarray );
	int tot = 0;
	for (int i = 0 ; i < yyvsp[-2].ribarray->nelems ; i++)
		tot += nverts[i];
	if (tot != yyvsp[-1].ribarray->nelems)
		ParseError("Wrong number of vertex elements in PointsPolygons. Ignoring.");
	else
		RiPointsPolygonsV( yyvsp[-2].ribarray->nelems, nverts, verts, CPS, CPT, CPA );

	delete [] nverts;
	delete [] verts;
	ArrayFree( yyvsp[-2].ribarray );
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 108:
#line 717 "ribparse.y"
{
	RtInt num_verts = -1;

	for (int i = 0 ; i < CPS ; i++) {
		if (CPT[i] == RI_P || strcmp(CPT[i], RI_P) == 0) {
			num_verts = CPSZ[i];
			if (num_verts % 3 != 0) {
				ParseError( "RI_P array must be 3*n in length." );
				goto noGoodPolygon;
			}
			num_verts /= 3;
			break;
		}
	}
	if (num_verts == -1)
		ParseError( "Polygon without an RI_P parameter???" );
	else
		RiPolygonV( num_verts, CPS, CPT, CPA );
noGoodPolygon:
	;
;
    break;}
case 109:
#line 739 "ribparse.y"
{
	RiProjectionV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 110:
#line 743 "ribparse.y"
{
	RiQuantize( yyvsp[-4].string, RtInt(yyvsp[-3].num), RtInt(yyvsp[-2].num), RtInt(yyvsp[-1].num), yyvsp[0].num );
;
    break;}
case 111:
#line 747 "ribparse.y"
{
        RiRectangleV( yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 112:
#line 751 "ribparse.y"
{
	RiRelativeDetail( yyvsp[0].num );
;
    break;}
case 113:
#line 755 "ribparse.y"
{
	RiReverseOrientation();
;
    break;}
case 114:
#line 759 "ribparse.y"
{
	RiRotate( yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 115:
#line 763 "ribparse.y"
{
	RiScale( yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 116:
#line 767 "ribparse.y"
{
	RiScreenWindow( yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 117:
#line 771 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 4, "ScreenWindow" ))
		RiScreenWindow( NA(yyvsp[0].ribarray)[0], NA(yyvsp[0].ribarray)[1], NA(yyvsp[0].ribarray)[2], NA(yyvsp[0].ribarray)[3] );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 118:
#line 777 "ribparse.y"
{
	RiShadingInterpolation( yyvsp[0].string );
;
    break;}
case 119:
#line 781 "ribparse.y"
{
	RiShadingRate( yyvsp[0].num );
;
    break;}
case 120:
#line 785 "ribparse.y"
{
	RiShutter( yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 121:
#line 789 "ribparse.y"
{
	RiSides( RtInt(yyvsp[0].num) );
;
    break;}
case 122:
#line 793 "ribparse.y"
{
	RiSkew( yyvsp[-6].num, yyvsp[-5].num, yyvsp[-4].num, yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 123:
#line 797 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 7, "Skew" ))
		RiSkew( NA(yyvsp[0].ribarray)[0], NA(yyvsp[0].ribarray)[1], NA(yyvsp[0].ribarray)[2], NA(yyvsp[0].ribarray)[3],
				NA(yyvsp[0].ribarray)[4], NA(yyvsp[0].ribarray)[5], NA(yyvsp[0].ribarray)[6] );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 124:
#line 804 "ribparse.y"
{
	RiSolidBegin( yyvsp[0].string );
;
    break;}
case 125:
#line 808 "ribparse.y"
{
	RiSolidEnd();
;
    break;}
case 126:
#line 812 "ribparse.y"
{
	RiSphereV( yyvsp[-4].num, yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 127:
#line 816 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[-1].ribarray, 4, "Sphere" ))
		RiSphereV( NA(yyvsp[-1].ribarray)[0], NA(yyvsp[-1].ribarray)[1], NA(yyvsp[-1].ribarray)[2], NA(yyvsp[-1].ribarray)[3], CPS, CPT, CPA );
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 128:
#line 822 "ribparse.y"
{
	RiSurfaceV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 129:
#line 826 "ribparse.y"
{
	RiTextureCoordinates( yyvsp[-7].num, yyvsp[-6].num, yyvsp[-5].num, yyvsp[-4].num,
						  yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 130:
#line 831 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 8, "TextureCoordinates" ))
		RiTextureCoordinates( NA(yyvsp[0].ribarray)[0], NA(yyvsp[0].ribarray)[1], NA(yyvsp[0].ribarray)[2], NA(yyvsp[0].ribarray)[3],
							  NA(yyvsp[0].ribarray)[4], NA(yyvsp[0].ribarray)[5], NA(yyvsp[0].ribarray)[7], NA(yyvsp[0].ribarray)[8] );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 131:
#line 838 "ribparse.y"
{
	RiTorus( yyvsp[-5].num, yyvsp[-4].num, yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 132:
#line 842 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[-1].ribarray, 5, "Torus" ))
		RiTorus( NA(yyvsp[-1].ribarray)[0], NA(yyvsp[-1].ribarray)[1], NA(yyvsp[-1].ribarray)[2], NA(yyvsp[-1].ribarray)[3], NA(yyvsp[-1].ribarray)[4],
			CPS, CPT, CPA );
    ArrayFree(yyvsp[-1].ribarray);
;
    break;}
case 133:
#line 849 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 16, "Transform" ))
		RiTransform( (RtFloat *) yyvsp[0].ribarray->array );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 134:
#line 855 "ribparse.y"
{
	RiTransformBegin();
;
    break;}
case 135:
#line 859 "ribparse.y"
{
	RiTransformEnd();
;
    break;}
case 136:
#line 863 "ribparse.y"
{
	RiTranslate( yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 137:
#line 867 "ribparse.y"
{
	RtInt *ncurves, *order, *n;

	ncurves = MakeIntArray( yyvsp[-8].ribarray );
	order = MakeIntArray( yyvsp[-7].ribarray );
	n = MakeIntArray( yyvsp[-3].ribarray );

	RiTrimCurve( yyvsp[-8].ribarray->nelems, ncurves, order, NA(yyvsp[-6].ribarray), NA(yyvsp[-5].ribarray), NA(yyvsp[-4].ribarray), n, NA(yyvsp[-2].ribarray), NA(yyvsp[-1].ribarray), NA(yyvsp[0].ribarray) );
	delete [] ncurves;
	delete [] order;
	delete [] n;

	ArrayFree( yyvsp[-8].ribarray );
	ArrayFree( yyvsp[-7].ribarray );
	ArrayFree( yyvsp[-6].ribarray );
	ArrayFree( yyvsp[-5].ribarray );
	ArrayFree( yyvsp[-4].ribarray );
	ArrayFree( yyvsp[-3].ribarray );
	ArrayFree( yyvsp[-2].ribarray );
	ArrayFree( yyvsp[-1].ribarray );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 138:
#line 890 "ribparse.y"
{
	RiWorldBegin();
;
    break;}
case 139:
#line 894 "ribparse.y"
{
	RiWorldEnd();
;
    break;}
}

#line 705 "/usr/share/bison/bison.simple"


  yyvsp -= yylen;
  yyssp -= yylen;
#if YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG
  if (yydebug)
    {
      short *yyssp1 = yyss - 1;
      YYFPRINTF (stderr, "state stack now");
      while (yyssp1 != yyssp)
	YYFPRINTF (stderr, " %d", *++yyssp1);
      YYFPRINTF (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;
#if YYLSP_NEEDED
  *++yylsp = yyloc;
#endif

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("parse error, unexpected ") + 1;
	  yysize += yystrlen (yytname[YYTRANSLATE (yychar)]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "parse error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[YYTRANSLATE (yychar)]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exhausted");
	}
      else
#endif /* defined (YYERROR_VERBOSE) */
	yyerror ("parse error");
    }
  goto yyerrlab1;


/*--------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action |
`--------------------------------------------------*/
yyerrlab1:
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;
      YYDPRINTF ((stderr, "Discarding token %d (%s).\n",
		  yychar, yytname[yychar1]));
      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;


/*-------------------------------------------------------------------.
| yyerrdefault -- current state does not do anything special for the |
| error token.                                                       |
`-------------------------------------------------------------------*/
yyerrdefault:
#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */

  /* If its default is to accept any token, ok.  Otherwise pop it.  */
  yyn = yydefact[yystate];
  if (yyn)
    goto yydefault;
#endif


/*---------------------------------------------------------------.
| yyerrpop -- pop the current state because it cannot handle the |
| error token                                                    |
`---------------------------------------------------------------*/
yyerrpop:
  if (yyssp == yyss)
    YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#if YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG
  if (yydebug)
    {
      short *yyssp1 = yyss - 1;
      YYFPRINTF (stderr, "Error: state stack now");
      while (yyssp1 != yyssp)
	YYFPRINTF (stderr, " %d", *++yyssp1);
      YYFPRINTF (stderr, "\n");
    }
#endif

/*--------------.
| yyerrhandle.  |
`--------------*/
yyerrhandle:
  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;
#if YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

/*---------------------------------------------.
| yyoverflowab -- parser overflow comes here.  |
`---------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}
#line 897 "ribparse.y"

