typedef struct Photon {
    float pos[3];
    short plane;
    unsigned char theta, phi;
    float power[3];
} Photon;

typedef struct NearestPhotons {
    int max;
    int found;
    int gotHeap;
    float pos[3];
    float *dist2;
    const Photon **index;
} NearestPhotons;

class PhotonMap {
  public:
    PhotonMap( int maxPhot );
    ~PhotonMap();

    void store( const float power[3], const float pos[3], const float dir[3] );
    void scalePhotonPower( const float scale );
    void balance( void );
    void irradianceEstimate( float irrad[3], const float pos[3], const float normal[3],
        const float maxDist, const int nPhotons ) const;
    void locatePhotons( NearestPhotons * const np, const int index ) const;
    void photonDir( float * dir, const Photon * p ) const;
    void writeToDisk( const char * fileName );
    void readFromDisk( const char * fileName, int numPhotons ); 

  private:
    void balanceSegment( Photon **pbal, Photon **porg, const int index,
        const int start, const int end );
    void medianSplit( Photon **p, const int start, const int end,
        const int median, const int axis );
    
    Photon * photons;
    int storedPhotons;
    int halfStoredPhotons;
    int maxPhotons;
    int prevScale;
    float costheta[256];
    float sintheta[256];
    float cosphi[256];
    float sinphi[256];
    float bboxMin[3];
    float bboxMax[3];
}; 
