#ifndef LIGHT_H
#define LIGHT_H
#include "lrt.h"
#include "geometry.h"
#include "transform.h"
#include "color.h"
class Light {
public:
	virtual ~Light();
	Light(bool shadows, const Transform &world2light,
			const Spectrum &power) {
		CastsShadows = shadows;
		WorldToLight = world2light;
		LightToWorld = Transform(WorldToLight.GetInverse());
		Power = power;
	}
	virtual Spectrum dE(const Scene *scene,
		const DifferentialGeometry &dg, const Vector &w) const;
	virtual Spectrum dE(const Scene *scene,
		const DifferentialGeometry &dg,	Vector *w) const;
	bool visible(const Scene *scene, const Point &x1,
		const Point &x2) const;
	float unoccluded(const Scene *scene, const Point &x, const Vector &w) const;
	#if 0
	virtual Spectrum E(const DifferentialGeometry &dg, Vector *w) const = 0;
	#endif
	virtual Spectrum sample_dE(const Scene *scene,
			const DifferentialGeometry &dg, Vector *wo,
			Float *weight) const;
	Float weight(const Point &, const Vector &) const {
		return 1.f;
	}
protected:
	bool CastsShadows;
	Transform WorldToLight, LightToWorld;
	Spectrum Power;
};
class PointLight : public Light {
public:
	PointLight(bool shadows, const Transform &world2light,
		const Spectrum &power, const Point &Plight);
	virtual Spectrum I(const Vector &w) const {
		return Power / (4*M_PI);
	}
	Spectrum dE(const Scene *scene, const DifferentialGeometry &dg, Vector *w) const;
private:
	Point lightPos;
};
class InfinitePointLight : public Light {
public:
	InfinitePointLight(bool shadows,const Transform &world2light,
		const Spectrum &power, const Vector &dir);
	Spectrum dE(const Scene *scene, const DifferentialGeometry &dg, Vector *w) const;
private:
	Vector lightDir;
};
class AreaLight : public Light {
public:
	AreaLight(bool shadows, const Transform &world2light,
		const Spectrum &power, Shape *shape);
	const Shape *GetShape() const { return shape; }
	virtual Spectrum L(const Point &x, const Vector &w) const {
		return Power/(Area * M_PI);
	}
	virtual Spectrum B(const Point &x) {
		return Power/Area;
	}
	Spectrum dE(const Scene *scene, const DifferentialGeometry &dg,
		const Vector &w) const;
	virtual Spectrum sample_dE(const Scene *scene,
			const DifferentialGeometry &dg, Vector *wo,
			Float *weight) const;
        void sampleLightRay( Ray * ray );
protected:
	const Shape *shape;
	Float Area;
};
class InfiniteAreaLight : public Light {
public:
	InfiniteAreaLight(bool shadows,	const Spectrum &power);
	Spectrum dE(const Scene *scene, const DifferentialGeometry &dg,
		const Vector &w) const;
	virtual Spectrum sample_dE(const Scene *scene,
			const DifferentialGeometry &dg, Vector *wo,
			Float *weight);
};
class AmbientLight : public Light {
public:
	AmbientLight(const Spectrum &p);
	Spectrum dE(const Scene *scene, const DifferentialGeometry &dg, const Vector &w) const;
};
#endif // LIGHT_H
