#include "lrt.h"
#include "geometry.h"
Point Lerp(Float t, const Point &p1, const Point &p2) {
	Float x = Lerp( t, p1.x, p2.x );
	Float y = Lerp( t, p1.y, p2.y );
	Float z = Lerp( t, p1.z, p2.z );
	return Point( x, y, z );
}
BBox Union(const BBox &b, const Point &p) {
	BBox ret = b;
	ret.pMin.x = min(b.pMin.x, p.x);
	ret.pMin.y = min(b.pMin.y, p.y);
	ret.pMin.z = min(b.pMin.z, p.z);
	ret.pMax.x = max(b.pMax.x, p.x);
	ret.pMax.y = max(b.pMax.y, p.y);
	ret.pMax.z = max(b.pMax.z, p.z);
	return ret;
}
BBox Union(const BBox &b, const BBox &b2 ) {
	BBox ret;
	ret.pMin.x = min(b.pMin.x, b2.pMin.x);
	ret.pMin.y = min(b.pMin.y, b2.pMin.y);
	ret.pMin.z = min(b.pMin.z, b2.pMin.z);
	ret.pMax.x = max(b.pMax.x, b2.pMax.x);
	ret.pMax.y = max(b.pMax.y, b2.pMax.y);
	ret.pMax.z = max(b.pMax.z, b2.pMax.z);
	return ret;
}
BBox Intersection(const BBox &b1, const BBox &b2) {
    BBox ret;
	ret.pMin.x = max(b1.pMin.x, b2.pMin.x);
	ret.pMin.y = max(b1.pMin.y, b2.pMin.y);
	ret.pMin.z = max(b1.pMin.z, b2.pMin.z);
	ret.pMax.x = min(b1.pMax.x, b2.pMax.x);
	ret.pMax.y = min(b1.pMax.y, b2.pMax.y);
	ret.pMax.z = min(b1.pMax.z, b2.pMax.z);
	Assert(ret.pMin.x <= ret.pMax.x);
	Assert(ret.pMin.y <= ret.pMax.y);
	Assert(ret.pMin.z <= ret.pMax.z);
	return ret;
}
bool BBox::IntersectP( const Ray &ray ) const {
        if ( Inside( ray.O ) ) {
            ray.maxt = 0;
            return true; 
        }
	Float t0 = ray.mint, t1 = ray.maxt;
	Float invRayDir = 1. / ray.D.x;
	Float tNear = (pMin.x - ray.O.x) * invRayDir;
	Float tFar  = (pMax.x - ray.O.x) * invRayDir;
	if (tNear > tFar) swap(tNear, tFar);
	t0 = max(tNear, t0);
	t1 = min(tFar,  t1);
	if (t0 > t1) return false;
	invRayDir = 1. / ray.D.y;
	tNear = (pMin.y - ray.O.y) * invRayDir;
	tFar  = (pMax.y - ray.O.y) * invRayDir;
	if (tNear > tFar) swap(tNear, tFar);
	t0 = max(tNear, t0);
	t1 = min(tFar,  t1);
	if (t0 > t1) return false;
	invRayDir = 1. / ray.D.z;
	tNear = (pMin.z - ray.O.z) * invRayDir;
	tFar  = (pMax.z - ray.O.z) * invRayDir;
	if (tNear > tFar) swap(tNear, tFar);
	t0 = max(tNear, t0);
	t1 = min(tFar,  t1);
	if (t0 > t1) return false;
	ray.maxt = t0;
	return true;
}
