#ifndef FILM_H
#define FILM_H
#include "lrt.h"
#include "color.h"
#include "image.h"
#include "geometry.h"
#include "transform.h"
class Film {
public:
	Film(Image *image, Float left, Float right, Float top, Float bottom);
	virtual ~Film();
	Image *GetImage() const { return image; }
	Transform GetRasterToScreen() const { return RasterToScreen; }
	virtual void AddSample(const Point &PRas, const Spectrum &radiance,
		Float alpha) = 0;
protected:
	Image *image;
	Float ScreenLeft, ScreenRight, ScreenBottom, ScreenTop;
	Transform ScreenToRaster, RasterToScreen;
};
class ColorFilm : public Film {
public:
	ColorFilm(Image *image, Float left, Float right, Float top, Float bottom)
		: Film(image, left, right, top, bottom) {}
	virtual void AddSample(const Point &PRas, const Spectrum &radiance,
		Float alpha );
};
class BWFilm : public Film {
public:
	BWFilm(Image *image, Float left, Float right, Float top, Float bottom)
		: Film(image, left, right, top, bottom) {}
	virtual void AddSample(const Point &PRas, const Spectrum &radiance,
		Float alpha );
};
class DepthFilm : public Film {
public:
	DepthFilm(Image *image, Float left, Float right, Float top, Float bottom)
		: Film(image, left, right, top, bottom) {}
	virtual void AddSample(const Point &PRas, const Spectrum &radiance,
		Float alpha );
};
#endif // FILM_H
