#ifndef TRANSPORT_H
#define TRANSPORT_H
#include "lrt.h"
#include "photonmap.h"
class Integrator {
public:
	virtual ~Integrator();
	virtual Spectrum L(const Scene *scene,
		const Ray &ray,	Float *alpha) const = 0;
	virtual void setPhotonMap(PhotonMap* map){
	  photonmap = map;
	}
	PhotonMap* photonmap;
};
class RayCastingIntegrator : public Integrator {
public:
	Spectrum L(const Scene *scene, const Ray &ray,
		Float *alpha) const;
};

class PhotonVisIntegrator : public Integrator {
public:
	Spectrum L(const Scene *scene, const Ray &ray,
		Float *alpha) const;
};

class PhotonMapIntegrator : public Integrator {
public:
	PhotonMapIntegrator(int md) {
		MaxDepth = md;
	}
	Spectrum L(const Scene *scene, const Ray &ray,
		   Float *alpha) const;
	static int RayDepth;
private:
	Spectrum DirectL(const Scene *scene, const Ray &ray,
			 Surf &surf, Float *alpha) const;
	Spectrum IndirectL(const Scene *scene, const Ray &ray,
			   Surf &surf, Float *alpha) const;
	int MaxDepth;
};

class FinalGatheringIntegrator : public Integrator {
public:
	FinalGatheringIntegrator(int md) {
		MaxDepth = md;
	}
	Spectrum L(const Scene *scene, const Ray &ray,
		   Float *alpha) const;
	static int RayDepth;
private:
	Spectrum DirectL(const Scene *scene, const Ray &ray,
			 Surf &surf, Float *alpha) const;
	Spectrum IndirectL(const Scene *scene, const Ray &ray,
			   Surf &surf, Float *alpha) const;
	Spectrum IndirectContribution(const Scene *scene,
			   const Ray &ray, Float *alpha) const;
	int MaxDepth;
};

class WhittedIntegrator : public Integrator {
public:
	WhittedIntegrator(int md) {
		MaxDepth = md;
	}
	Spectrum L(const Scene *scene, const Ray &ray, Float *alpha = NULL) const;
	static int RayDepth;
private:
	int MaxDepth;
};
class PathIntegrator : public Integrator {
public:
	Spectrum L(const Scene *scene, const Ray &ray, Float *alpha) const;
};
class MCIntegrator : public Integrator {
public:
	Spectrum L(const Scene *scene, const Ray &ray, Float *alpha) const;
};
#endif // TRANSPORT_H
