#ifndef LIGHT_H
#define LIGHT_H
#include "lrt.h"
#include "geometry.h"
#include "transform.h"
#include "color.h"

//**********************
typedef struct EnvMap {
//**********************
  float phi, theta;
  Spectrum value;
} EnvMap;

// num must be of the form (2n)^2
void gen_stratified_samples(Vector w[], int num);

class Light {
public:
	virtual ~Light();
	Light(bool shadows, const Transform &world2light,
			const Spectrum &power) {
		CastsShadows = shadows;
		WorldToLight = world2light;
		LightToWorld = Transform(WorldToLight.GetInverse());
		Power = power;
	}
	virtual Spectrum dE(const Scene *scene,
		const DifferentialGeometry &dg, const Vector &w) const;
	virtual Spectrum dE(const Scene *scene,
		const DifferentialGeometry &dg,	Vector *w) const;
	bool visible(const Scene *scene, const Point &x1,
		const Point &x2) const;
	float unoccluded(const Scene *scene, const Point &x, const Vector &w) const;
	#if 0
	virtual Spectrum E(const DifferentialGeometry &dg, Vector *w) const = 0;
	#endif
	virtual Spectrum sample_dE(const Scene *scene,
			const DifferentialGeometry &dg, Vector *wo,
			Float *weight) const;
	Float weight(const Point &, const Vector &) const {
		return 1.f;
	}	
	Spectrum Power;
	bool CastsShadows;
protected:
	Transform WorldToLight, LightToWorld;

};
class PointLight : public Light {
public:
	PointLight(bool shadows, const Transform &world2light,
		const Spectrum &power, const Point &Plight);
	virtual Spectrum I(const Vector &w) const {
		return Power / (4*M_PI);
	}
	Spectrum dE(const Scene *scene, const DifferentialGeometry &dg, Vector *w) const;
	//private:
	Point lightPos;
};
class InfinitePointLight : public Light {
public:
	InfinitePointLight(bool shadows,const Transform &world2light,
		const Spectrum &power, const Vector &dir);
	Spectrum dE(const Scene *scene, const DifferentialGeometry &dg, Vector *w) const;
	//private:
	Vector lightDir;
};
class AreaLight : public Light {
public:
	AreaLight(bool shadows, const Transform &world2light,
		const Spectrum &power, Shape *shape);
	const Shape *GetShape() const { return shape; }
	virtual Spectrum L(const Point &x, const Vector &w) const {
		return Power/(Area * M_PI);
	}
	virtual Spectrum B(const Point &x) {
		return Power/Area;
	}
	Spectrum dE(const Scene *scene, const DifferentialGeometry &dg,
		const Vector &w) const;
	virtual Spectrum sample_dE(const Scene *scene,
			const DifferentialGeometry &dg, Vector *wo,
			Float *weight) const;
protected:
	const Shape *shape;
	Float Area;
};
class EnvironmentLight : public Light {
public:
	EnvironmentLight(bool shadows, const Transform &world2light,
			 const Spectrum &power, float time);
	~EnvironmentLight() { delete light_array; }
	Spectrum dE(const Scene *scene, const DifferentialGeometry &dg,
		const Vector &w);
	Spectrum sample_dE(const Scene *scene,
			const DifferentialGeometry &dg, Vector *wo,
			Float *weight) const;
	//Spectrum E(Vector v);
	//Spectrum E(float theta, float phi);
	//protected:
	Spectrum ComputeE(Vector v);
	Spectrum ComputeE(float theta, float phi);
	Spectrum SkyColor(float sunPhi);
	//Spectrum *env;
	EnvMap* light_array;
	int light_array_size;
	float sunTheta, sunPhi;
	Vector sunVector;
	Spectrum skyBase;
};

class InfiniteAreaLight : public Light {
public:
	InfiniteAreaLight(bool shadows,	const Spectrum &power);
	Spectrum dE(const Scene *scene, const DifferentialGeometry &dg,
		    const Vector &w) const;
	virtual Spectrum sample_dE(const Scene *scene,
				   const DifferentialGeometry &dg, Vector *wo,
			Float *weight);
};
class AmbientLight : public Light {
public:
	AmbientLight(const Spectrum &p);
	Spectrum dE(const Scene *scene, const DifferentialGeometry &dg, const Vector &w) const;
};
#endif // LIGHT_H
