#include "materials.h"
#include "color.h"
#include "reflection.h"
#include "texture.h"
DifferentialGeometry Material::bump(
	const DifferentialGeometry &dgg) const {
	return dgg;
}
Matte::~Matte() {
	delete Kd;
}
BSDF *Matte::getBSDF(const Surf *surf) const {
	Spectrum r = Kd->evaluate(surf);
	return new BSDF(surf->dgShading,
		new LambertianReflection(r), 1., NULL);
}
Plastic::~Plastic() {
	delete Kd;
	delete Ks;
	delete roughness;
}
BSDF *Plastic::getBSDF(const Surf *surf) const {
	BxDF *diff = new LambertianReflection(Kd->evaluate(surf));
	BxDF *spec = new Microfacet(Ks->evaluate(surf),
		new Blinn(1. / roughness->evaluate(surf)));
	return new BSDF(surf->dgShading, diff, 1., spec, 1., NULL);
}


Glass::~Glass() {
	delete Kr;
	delete Kt;
	delete index;
}
BSDF *Glass::getBSDF(const Surf *surf) const {
	Spectrum R = Kr->evaluate(surf), T = Kt->evaluate(surf);
	Float ior = index->evaluate(surf);
	BxDF *brdf = NULL, *btdf = NULL;
	if (R.Intensity() > 0.)
		brdf = new SpecularReflection(R);
	if (T.Intensity() > 0.)
		btdf = new SpecularTransmission(T, 1., ior);
	if (brdf && btdf) return new BSDF(surf->dgShading, brdf, 1.,
						btdf, 1., NULL);
	else if (brdf)    return new BSDF(surf->dgShading, brdf, 1., NULL);
	else if (btdf)    return new BSDF(surf->dgShading, btdf, 1., NULL);
	else              return new BSDF(surf->dgShading, NULL);
}
ShinyMetal::~ShinyMetal() {
	delete Ks;
	delete roughness;
	delete Kr;
}
BSDF *ShinyMetal::getBSDF(const Surf *surf) const {
	Spectrum spec = Ks->evaluate(surf);
	Float rough = roughness->evaluate(surf);
	Spectrum R = Kr->evaluate(surf);

	MicrofacetDistribution *md = new Blinn(1. / rough);
	return new BSDF(surf->dgShading, new Microfacet(spec, md), 1.,
		new SpecularReflection(R), 1., NULL, NULL);
}
ThinFilm::~ThinFilm() {
	delete Kd;
	delete Kr;
	delete thickness;
	delete transmission;
}
BSDF *ThinFilm::getBSDF(const Surf *surf) const {
        Spectrum diffuse = Kd->evaluate(surf);
	Float thick = thickness->evaluate(surf);
	Float trans = transmission->evaluate(surf);
	Float mod = modulation->evaluate(surf);
     
	BxDF *tf = new ThinFilmReflection(diffuse, surf->dgShading.N,
					  thick, trans, mod, surf->dgShading.t);
	return new BSDF(surf->dgShading, tf, 1., 1., NULL, NULL);
}
