#ifndef SCENE_H
#define SCENE_H
#include "lrt.h"
#include "primitives.h"

class Scene {
public:
  static int numIntersectTests;
  static int numShadings;
  enum DofMethod {stratified, disks, spotted};
	Scene(Camera *c, Integrator *in, Image *img, Sampler *s,
		const vector<Primitive *> &prims, const vector<Light *> &lts);
	Spectrum L(const Ray &ray) const;
	bool Intersect(const Ray &ray, Surf *surf) const;
	bool IntersectP( const Ray &ray ) const;
	Float Visibility(Surf& surf, int numLevels = 3);
	Float SceneLeakage(Ray& ray, int numLevels = 2);
	void TraceThrough(Point& imagePoint,
			  Ray& ray, Surf& hit, Float wt = 1);
	bool RandomShadingOfPoint(Point& P, Surf& hit,
				  Spectrum& L, Float& alpha);
	void HandleFoundPoint(DofMethod method,
			      Float xSource, Float ySource, Float screenz,
			      Surf hit, Float wt = 1.);
	void HandleMiss(Ray ray, Float wt = 1.);
	void Render();
	void ApplyRenderAlgorithm(DofMethod method, Float wt = 1);
	~Scene();
	Integrator *integrator;
	Camera *camera;
	Image *image;
	Sampler *sampler;
	vector<Light *> lights;
private:
	PrimitiveSet *prims;
};


#endif // SCENE_H
