#ifndef IMAGE_H
#define IMAGE_H
#include "lrt.h"
#include "color.h"
class Image {
public:
	Image(int xres, int yres, Float cropx0, Float cropx1, Float cropy0, Float cropy1,
		bool doRGB, bool doA, Imager *im, Float gain, Float gamma,
		int colQuantOne, int colQuantMin, int colQuantMax, Float colQuantDither,
		char *display, Sampler *sampler);
	int GetXResolution() const { return XResolution; }
	int GetYResolution() const { return YResolution; }
	~Image();
	void AddSampleBasic(const Point &PRaster, const Spectrum &radiance,
		Float alpha);
	void Write() const;
	void AddSample(const Point &PRaster, const Spectrum &radiance,
		       Float alpha, Float wt = 1);
	int XResolution, YResolution;
	Float CropLeft, CropRight, CropBottom, CropTop;
	Float Gain, Gamma;
	Imager *imager;
	int ColorQuantOne, ColorQuantMin, ColorQuantMax;
	Float ColorQuantDither;
	char *DisplayName;
	char *ImageViewer;
	Float SampleCropLeft, SampleCropRight;
	Float SampleCropTop, SampleCropBottom;
	Sampler *sampler;
	int XBase, YBase, XWidth, YWidth;
private:
	static void scaleAndDither(Float one, Float min, Float max, Float dither,
		Float *pixels, int nPixels);
	Spectrum *Pixels;
	Float *Alphas;
	Float *WeightSums;
};
class Imager {
public:
	virtual ~Imager();
	virtual void Apply(const Spectrum &, float a, float z) const = 0;
};
#endif // IMAGE_H
