#ifndef HEIGHTFIELD_H
#define HEIGHTFIELD_H
#include "shapes.h"

class HfAccel {
 public:
  virtual bool Intersect(const Ray &ray, DifferentialGeometry *dg) const = 0;
  virtual bool IntersectP(const Ray &ray) const = 0;
};

class HfTree : public HfAccel {
 public:
  const static Normal vertSplitN, horSplitN, diagN;
  HfTree(Point *P, Normal *N,
	 int xi0, int xi1, int yi0, int yi1, int nx, int ny);
  virtual ~HfTree();
  virtual bool Intersect(const Ray &ray, DifferentialGeometry *dg) const;
  virtual bool IntersectP(const Ray &ray) const;
 private:
  BBox *box;
  Normal splitNormal;
  HfAccel *belowSplitPlane;
  HfAccel *aboveSplitPlane;
};

class HfTriangle : public HfAccel {
 public:
  HfTriangle(Point P0, Point P1, Point P2, Normal N0, Normal N1, Normal N2)
    : E1((P1 - P0).x, (P1 - P0).y, (P1 - P0).z),
    E2((P2 - P0).x, (P2 - P0).y, (P2 - P0).z),
    P0(P0), P1(P1), P2(P2), N0(N0), N1(N1), N2(N2) {}
  virtual bool Intersect(const Ray &ray, DifferentialGeometry *dg) const;
  virtual bool IntersectP(const Ray &ray) const;
 private:
  Vector E1, E2;
  Point P0;
  Point P1, P2;  // ** debug! **
  Normal N0, N1, N2;
};

class Heightfield : public Shape {
public:
	Heightfield(const Transform &o2w, int nu, int nv, float *zs);
	~Heightfield();
        bool Intersect(const Ray &ray, DifferentialGeometry *dg) const;
	bool IntersectP(const Ray &ray) const;
	virtual BBox Bound() const;
private:
	float *z;
	int nx, ny;
	HfTree *Tree;
};

#endif
