#include <cmath>
#include <cstdio>
#include <cstdlib>
#include <cstring>

// PLEASE NOTE: I assume sizeof(int)==sizeof(float)==4 in the read/write code


using namespace std;


//============================= inlines etc. ==================================

#if __BYTE_ORDER == __LITTLE_ENDIAN
static inline bool fwrite_32 (const void *buf, unsigned int n, FILE *stream)
{
	return (fwrite (buf, 4, n, stream) != n);
}

static inline bool fread_32 (void *buf, unsigned int n, FILE *stream)
{
	return (fread (buf, 4, n, stream) != n);
}
#else
static bool fwrite_32 (const void *buf, unsigned int n, FILE *stream)
{
	for (int i=0; i < n; ++i) {
		if (fwrite (4*i+3+(char*)buf, 1, 1, stream) != 1) return 1;
		if (fwrite (4*i+2+(char*)buf, 1, 1, stream) != 1) return 1;
		if (fwrite (4*i+1+(char*)buf, 1, 1, stream) != 1) return 1;
		if (fwrite (4*i+0+(char*)buf, 1, 1, stream) != 1) return 1;
	}
	return 0;
}

static inline bool fread_32 (void *buf, unsigned int n, FILE *stream)
{
	for (int i=0; i < n; ++i) {
		if (fread (4*i+3+(char*)buf, 1, 1, stream) != 1) return 1;
		if (fread (4*i+2+(char*)buf, 1, 1, stream) != 1) return 1;
		if (fread (4*i+1+(char*)buf, 1, 1, stream) != 1) return 1;
		if (fread (4*i+0+(char*)buf, 1, 1, stream) != 1) return 1;
	}
	return 0;
}
#endif


int main (int argc, char **argv)
{
	if (argc != 3) {
		fprintf (stderr,"usage:  %s <texname> <N>\n",argv[0]);
		return -1;
	}
	int N = atoi(argv[2]);
	if (N <= 0) return -1;
	float *tex = new float[N*N*N];


#define t(a,b,c) (tex[(a)+N*((b)+N*(c))])
	for (int i = 0; i < N*N*N; ++i) {
		tex[i] = rand()/(float)RAND_MAX - .5;
	}
	for (int i = 0; i < N; ++i)
		for (int j = 0; j < N; ++j)
			for (int k = 0; k < N; ++k) {
				int mi = i>0 ? i-1 : N-1, pi = i<N-1 ? i+1 : 0;
				int mj = j>0 ? j-1 : N-1, pj = j<N-1 ? j+1 : 0;
				int mk = k>0 ? k-1 : N-1, pk = k<N-1 ? k+1 : 0;
				t(i,j,k) = (2*t(i,j,k) + t(mi,j,k) + t(pi,j,k) + t(i,mj,k) + t(i,pj,k) + t(i,j,mk) + t(i,j,pk))/8;
			}
	for (int i = 0; i < N; ++i)
		for (int j = 0; j < N; ++j)
			for (int k = 0; k < N; ++k) {
				int mi = i>0 ? i-1 : N-1, pi = i<N-1 ? i+1 : 0;
				int mj = j>0 ? j-1 : N-1, pj = j<N-1 ? j+1 : 0;
				int mk = k>0 ? k-1 : N-1, pk = k<N-1 ? k+1 : 0;
				t(i,j,k) = (2*t(i,j,k) + t(mi,j,k) + t(pi,j,k) + t(i,mj,k) + t(i,pj,k) + t(i,j,mk) + t(i,j,pk))/8;
			}
	float maxtex = 0;
	for (int i = 0; i < N*N*N; ++i) if (fabs(tex[i]) > maxtex) maxtex = fabs(tex[i]);
	printf ("maxtex = %g\n", maxtex);
	for (int i = 0; i < N*N*N; ++i) tex[i] /= maxtex;
	maxtex = 0;
	for (int i = 0; i < N*N*N; ++i) if (fabs(tex[i]) > maxtex) maxtex = fabs(tex[i]);
	printf (" after rescaling maxtex = %g\n", maxtex);
#undef t

	FILE *fp = fopen(argv[1],"wb");
	fwrite_32 (&N, 1, fp);
	fwrite_32 (tex, N*N*N, fp);
	fclose(fp);
}

