#include "transform.h"
#include "shapes.h"
#include <iostream>
using std::endl;
Transform::Transform(Float t00, Float t01, Float t02, Float t03,
                     Float t10, Float t11, Float t12, Float t13,
                     Float t20, Float t21, Float t22, Float t23,
                     Float t30, Float t31, Float t32, Float t33) {
	m[0][0] = t00; m[0][1] = t01; m[0][2] = t02; m[0][3] = t03;
	m[1][0] = t10; m[1][1] = t11; m[1][2] = t12; m[1][3] = t13;
	m[2][0] = t20; m[2][1] = t21; m[2][2] = t22; m[2][3] = t23;
	m[3][0] = t30; m[3][1] = t31; m[3][2] = t32; m[3][3] = t33;
	ComputeInverse();
}
Transform::Transform(Float *matrix ) {
	memcpy( this->m, matrix, sizeof( this->m ) );
	ComputeInverse();
}

Transform::Transform(Float matrix[4][4] ) {
	memcpy( this->m, matrix, sizeof( this->m ) );
	ComputeInverse();
}
bool Transform::operator!=(const Transform &t2) const {
	for (int i = 0; i < 4; ++i)
		for (int j = 0; j < 4; ++j)
			if (m[i][j] != t2.m[i][j]) return true;
	return false;
}
ostream &operator<<(ostream &os, const Transform &t) {
	for (int i = 0; i < 4; ++i) {
		for (int j = 0; j < 4; ++j)
			os << t.m[i][j] << '\t';
		os << endl;
	}
	return os;
}
Transform Translate(const Vector &delta) {
	Transform ret( 1, 0, 0, delta.x,
				   0, 1, 0, delta.y,
				   0, 0, 1, delta.z,
				   0, 0, 0,    1     );
	return ret;
}
Transform RotateX(Float angle) {
    Float sin_t = sin(Radians(angle));
    Float cos_t = cos(Radians(angle));
    Transform ret( 1,   0,      0,   0,
				   0, cos_t, -sin_t, 0,
				   0, sin_t,  cos_t, 0,
				   0,   0,      0,   1 );
    return ret;
}
Transform RotateY(Float angle) {
    Float sin_t = sin(Radians(angle));
    Float cos_t = cos(Radians(angle));
    Transform ret( cos_t, 0, -sin_t, 0,
				     0,   1,   0,    0,
				   sin_t, 0 , cos_t, 0,
				     0,   0,   0,    1 );
    return ret;
}

Transform RotateZ(Float angle) {
    Float sin_t = sin(Radians(angle));
    Float cos_t = cos(Radians(angle));
    Transform ret( cos_t, -sin_t, 0, 0,
				   sin_t,  cos_t, 0, 0,
				     0,     0 ,   1, 0,
				     0,     0,    0, 1 );
    return ret;
}
Transform Rotate(Float angle, const Vector &a) {
	Vector axis = a.Hat();
	double s = sin(Radians(angle));
	double c = cos(Radians(angle));
	Float m[4][4];

	m[0][0] = axis.x * axis.x + (1. - axis.x * axis.x) * c;
	m[0][1] = axis.x * axis.y * (1 - c) - axis.z * s;
	m[0][2] = axis.x * axis.z * (1 - c) + axis.y * s;
	m[0][3] = 0;

	m[1][0] = axis.x * axis.y * (1 - c) + axis.z * s;
	m[1][1] = axis.y * axis.y + (1 - axis.y * axis.y) * c;
	m[1][2] = axis.y * axis.z * (1 - c) - axis.x * s;
	m[1][3] = 0;

	m[2][0] = axis.x * axis.z * (1 - c) - axis.y * s;
	m[2][1] = axis.y * axis.z * (1 - c) + axis.x * s;
	m[2][2] = axis.z * axis.z + (1 - axis.z * axis.z) * c;
	m[2][3] = 0;

	m[3][0] = 0;
	m[3][1] = 0;
	m[3][2] = 0;
	m[3][3] = 1;

	Transform ret( m );
	return ret;
}
Transform Scale(Float x, Float y, Float z) {
    Transform ret( x, 0, 0, 0,
				   0, y, 0, 0,
				   0, 0, z, 0,
				   0, 0, 0, 1 );
    return ret;
}
Transform Transform::operator*(const Transform &t2) const {
    Float retmatrix[4][4];
    for (int i = 0; i < 4; ++i) {
        for (int j = 0; j < 4; ++j) {
            retmatrix[i][j] = m[i][0] * t2.m[0][j] +
							  m[i][1] * t2.m[1][j] +
                			  m[i][2] * t2.m[2][j] +
							  m[i][3] * t2.m[3][j];
        }
    }
	Transform ret( retmatrix );
    return ret;
}
Point Transform::operator()(const Point &pt) const {
    Float x = pt.x, y = pt.y, z = pt.z;

    Float xp = m[0][0] * x + m[0][1] * y + m[0][2] * z + m[0][3];
    Float yp = m[1][0] * x + m[1][1] * y + m[1][2] * z + m[1][3];
    Float zp = m[2][0] * x + m[2][1] * y + m[2][2] * z + m[2][3];
    Float wp = m[3][0] * x + m[3][1] * y + m[3][2] * z + m[3][3];

    if (wp == 1.) return Point(xp, yp, zp);
    else          return Point(xp / wp, yp / wp, zp / wp);
}
Vector Transform::operator()(const Vector &v) const {
	Float x = v.x, y = v.y, z = v.z;

	Float xp = m[0][0] * x + m[0][1] * y + m[0][2] * z;
	Float yp = m[1][0] * x + m[1][1] * y + m[1][2] * z;
	Float zp = m[2][0] * x + m[2][1] * y + m[2][2] * z;

	return Vector(xp, yp, zp);
}
void Transform::ComputeInverse(void) {
	MatrixInvert( m, m_inverse );
}
Point Transform::InverseTransform(const Point &pt) const {
    Float x = pt.x, y = pt.y, z = pt.z;

    Float xp = m_inverse[0][0] * x + m_inverse[0][1] * y + m_inverse[0][2] * z + m_inverse[0][3];
    Float yp = m_inverse[1][0] * x + m_inverse[1][1] * y + m_inverse[1][2] * z + m_inverse[1][3];
    Float zp = m_inverse[2][0] * x + m_inverse[2][1] * y + m_inverse[2][2] * z + m_inverse[2][3];
    Float wp = m_inverse[3][0] * x + m_inverse[3][1] * y + m_inverse[3][2] * z + m_inverse[3][3];

    if (wp == 1.) return Point(xp, yp, zp);
    else          return Point(xp / wp, yp / wp, zp / wp);
}
Normal Transform::operator()(const Normal &n) const {
	Float x = n.x, y = n.y, z = n.z;

	Float xp = m_inverse[0][0] * x +
			   m_inverse[1][0] * y +
			   m_inverse[2][0] * z;
	Float yp = m_inverse[0][1] * x +
			   m_inverse[1][1] * y +
			   m_inverse[2][1] * z;
	Float zp = m_inverse[0][2] * x +
			   m_inverse[1][2] * y +
			   m_inverse[2][2] * z;

	return Normal(xp, yp, zp);
}
Ray Transform::operator()(const Ray &r) const {
	Point newO = (*this)(r.O);
	Vector newD = (*this)(r.D);
	return Ray(newO, newD, r.mint, r.maxt);
}
BBox Transform::operator()(const BBox &b) const {
	BBox ret((*this)(Point(b.pMin.x, b.pMin.y, b.pMin.z)));
	ret=Union(ret,(*this)(Point(b.pMax.x, b.pMin.y, b.pMin.z)));
	ret=Union(ret,(*this)(Point(b.pMin.x, b.pMax.y, b.pMin.z)));
	ret=Union(ret,(*this)(Point(b.pMin.x, b.pMin.y, b.pMax.z)));
	ret=Union(ret,(*this)(Point(b.pMin.x, b.pMax.y, b.pMax.z)));
	ret=Union(ret,(*this)(Point(b.pMax.x, b.pMax.y, b.pMin.z)));
	ret=Union(ret,(*this)(Point(b.pMax.x, b.pMin.y, b.pMax.z)));
	ret=Union(ret,(*this)(Point(b.pMax.x, b.pMax.y, b.pMax.z)));
	return ret;
}
Transform Orthographic(Float n, Float f) {
	Transform scale = Scale(1., 1., 1. / (f-n));
	Transform translate = Translate(Vector(0., 0., n));
	Transform ret = scale * translate;
	return Transform( ret.GetInverse() );
}
Transform Frustum(Float left, Float right,
				   Float bottom, Float top,
				   Float near, Float far) {
	Float m[4][4];

	m[0][0] = 2. * near / (right - left);
	m[0][1] = 0;
	m[0][2] = (right + left) / (right - left);
	m[0][3] = 0;

	m[1][0] = 0;
	m[1][1] = 2. * near / (top - bottom);
	m[1][2] = (top + bottom) / (top - bottom);
	m[1][3] = 0;

	m[2][0] = 0;
	m[2][1] = 0;
	m[2][2] = -(far + near) / (far - near);
	m[2][3] = 2. * far * near / (far - near);

	m[3][0] = 0;
	m[3][1] = 0;
	m[3][2] = -1.;
	m[3][3] = 0.;

	Transform ret(m);
	return ret;
}
Transform Perspective(Float fovy, Float aspect,
					   Float znear, Float zfar) {
	Float ymax = znear * tan(Radians(fovy) / 2.);
	Float ymin = -ymax;
	Float xmin = ymin * aspect;
	Float xmax = ymax * aspect;
	return Frustum(xmin, xmax, ymin, ymax, znear, zfar);
}
DifferentialGeometry Transform::operator()(
		const DifferentialGeometry &dg) const {
	const Transform &M = *this;
	return DifferentialGeometry(M(dg.P), M(dg.N), M(dg.S),
		M(dg.T), dg.u, dg.v);
}
