#ifndef SCENE_H
#define SCENE_H
#include "lrt.h"
class Scene {
public:
	Scene(Camera *c, Integrator *in, Image *img, Sampler *s,
		const vector<Primitive *> &prims, const vector<Light *> &lts, IlluminationMap *illmap);
	Spectrum L(const Ray &ray, bool directFromEye) const;
	bool Intersect(const Ray &ray, Surf *surf, bool directFromEye) const;
	bool IntersectP( const Ray &ray ) const;
	void Render();
	~Scene();
	Integrator *integrator;
	Camera *camera;
	Image *image;
	Sampler *sampler;
	vector<Light *> lights;
	IlluminationMap *illuminationMap;
private:
	PrimitiveSet *prims;
};
#endif // SCENE_H
