#include "scene.h"
#include "camera.h"
#include "primitives.h"
#include "image.h"
#include "transport.h"
#include "accel.h"
#include "sampling.h"
#include "illuminationmap.h"

Scene::~Scene() {
	delete camera;
	delete sampler;
	delete image;
	delete integrator;
}
Spectrum Scene::L(const Ray &ray, bool directFromEye) const {
	Float alpha = 1;
	Spectrum localL = integrator->L(this, ray, &alpha, directFromEye);
	if (illuminationMap && (!directFromEye || illuminationMap->directlyVisible)) {
		Spectrum distantL = illuminationMap->L(ray);
		return localL + (1-alpha)*distantL;							// I assume premultipled by alpha in integrator!
	} else
		return localL;
}
bool Scene::IntersectP(const Ray &ray) const {
	return prims->IntersectP(ray);
}
Scene::Scene(Camera *cam, Integrator *in, Image *img, Sampler *s,
		const vector<Primitive *> &pr,
		const vector<Light *> &lts, IlluminationMap *illmap) {
	lights = lts;
	prims = new GridAccelerator(pr);
	camera = cam;
	image = img;
	sampler = s;
	integrator = in;
	illuminationMap = illmap;
}
void Scene::Render() {
	cerr << "Rendering: ";
	Float sample[5];
	while (sampler->GetNextImageSample(sample)) {
		Ray ray;
		if (!camera->GenerateRay(sample, ray))
			continue;
		static int eyeRaysTraced = 0;
		if (eyeRaysTraced == 0)
			StatsRegisterCounter(STATS_BASIC, "Camera", "Eye Rays Traced",
				&eyeRaysTraced);
		++eyeRaysTraced;
		if (eyeRaysTraced % 10000 == 0) cerr << '+';
		Float alpha;
		Spectrum L = integrator->L(this, ray, &alpha, true);
		Float screenz = camera->WorldToScreen(ray(ray.maxt)).z;
		if (screenz > 1.) {
			L = Spectrum(0.);
			alpha = 0.;
		}
		if (alpha < 1 && illuminationMap && illuminationMap->directlyVisible) {
			Spectrum distantL = illuminationMap->L(ray);
			L += (1-alpha)*distantL;							// I assume premultipled by alpha in integrator!
			alpha = 1;
		}
		Point Praster(sample[0], sample[1], screenz);
		image->AddSample(Praster, L, alpha);
	}
	image->Write();
	cerr << endl;
}
bool Scene::Intersect(const Ray &ray, Surf *surf, bool directFromEye) const {
	return prims->Intersect(ray, surf, directFromEye);
}
