
/*  A Bison parser, made from ribparse.y
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define	STRING	257
#define	ID	258
#define	NUM	259
#define	LBRACK	260
#define	RBRACK	261
#define	DASH	262
#define	AREALIGHTSOURCE	263
#define	ATMOSPHERE	264
#define	ATTRIBUTE	265
#define	ATTRIBUTEBEGIN	266
#define	ATTRIBUTEEND	267
#define	BASIS	268
#define	BOUND	269
#define	CLIPPING	270
#define	COLOR	271
#define	COLORSAMPLES	272
#define	CONCATTRANSFORM	273
#define	CONE	274
#define	COORDINATESYSTEM	275
#define	CROPWINDOW	276
#define	CYLINDER	277
#define	DECLARE	278
#define	DEFORMATION	279
#define	DEPTHOFFIELD	280
#define	DETAIL	281
#define	DETAILRANGE	282
#define	DISK	283
#define	DISPLACEMENT	284
#define	DISPLAY	285
#define	EXPOSURE	286
#define	EXTERIOR	287
#define	FORMAT	288
#define	FRAMEASPECTRATIO	289
#define	FRAMEBEGIN	290
#define	FRAMEEND	291
#define	GENERALPOLYGON	292
#define	GEOMETRICAPPROXIMATION	293
#define	GEOMETRY	294
#define	HIDER	295
#define	HYPERBOLOID	296
#define	IDENTITY	297
#define	ILLUMINATE	298
#define	IMAGER	299
#define	INTERIOR	300
#define	LIGHTSOURCE	301
#define	MAKEBUMP	302
#define	MAKECUBEFACEENVIRONMENT	303
#define	MAKELATLONGENVIRONMENT	304
#define	ILLUMINATIONMAP	305
#define	MAKESHADOW	306
#define	MAKETEXTURE	307
#define	MATTE	308
#define	MOTIONBEGIN	309
#define	MOTIONEND	310
#define	NUPATCH	311
#define	OBJECTBEGIN	312
#define	OBJECTEND	313
#define	OBJECTINSTANCE	314
#define	OPACITY	315
#define	OPTION	316
#define	ORIENTATION	317
#define	PARABOLOID	318
#define	PATCH	319
#define	PATCHMESH	320
#define	FASTLEVELSET	321
#define	PERSPECTIVE	322
#define	PIXELFILTER	323
#define	PIXELSAMPLES	324
#define	PIXELVARIANCE	325
#define	POINTSGENERALPOLYGONS	326
#define	POINTSPOLYGONS	327
#define	POLYGON	328
#define	PROJECTION	329
#define	QUANTIZE	330
#define	RELATIVEDETAIL	331
#define	REVERSEORIENTATION	332
#define	ROTATE	333
#define	SCALE	334
#define	SCREENWINDOW	335
#define	SHADINGINTERPOLATION	336
#define	SHADINGRATE	337
#define	SHUTTER	338
#define	SIDES	339
#define	SKEW	340
#define	SOLIDBEGIN	341
#define	SOLIDEND	342
#define	SPHERE	343
#define	SURFACE	344
#define	TEXTURECOORDINATES	345
#define	TORUS	346
#define	TRANSFORM	347
#define	TRANSFORMBEGIN	348
#define	TRANSFORMEND	349
#define	TRANSLATE	350
#define	TRIMCURVE	351
#define	VERSION	352
#define	WORLDBEGIN	353
#define	WORLDEND	354
#define	HIGH_PRECEDENCE	355

#line 1 "ribparse.y"

#include "ri.h"
#include "lrt.h"

#include <stdarg.h>

extern int yylex( void );
int line_num = 1;

#define YYMAXDEPTH 100000000

void yyerror( char *str ) {
	Error( "RIB parsing error on line %d\n\t%s", line_num,str );
}

void ParseError( const char *format, ... ) PRINTF_FORMAT;

void ParseError( const char *format, ... ) {
	char error[4096];
	va_list args;
	va_start( args, format );
	vsprintf( error, format, args );
	yyerror(error);
	va_end( args );
}

// RI says 64k is the maxiumum light handle number
#define MAX_LIGHT_HANDLE 65536
static RtLightHandle lights[MAX_LIGHT_HANDLE];

int cur_paramlist_allocated = 0;
int cur_paramlist_size = 0;
RtToken *cur_paramlist_tokens = NULL;
RtPointer *cur_paramlist_args = NULL;
RtInt *cur_paramlist_sizes = NULL;

#define CPS cur_paramlist_size
#define CPT cur_paramlist_tokens
#define CPA cur_paramlist_args
#define CPSZ cur_paramlist_sizes

typedef struct RIB_array {
	int element_size;
	int allocated;
	int nelems;
	RtVoid *array;
} RIB_array;

RIB_array *cur_array = NULL;

#define NA(r) ((RtFloat *) r->array)
#define SA(r) ((const char **) r->array)

void AddArrayElement( void *elem ) {
	if (cur_array->nelems >= cur_array->allocated) {
		cur_array->allocated = 2*cur_array->allocated + 1;
		cur_array->array = realloc( cur_array->array,
			cur_array->allocated*cur_array->element_size );
	}
	char *next = ((char *)cur_array->array) + cur_array->nelems *
		cur_array->element_size;
	memcpy( next, elem, cur_array->element_size );
	cur_array->nelems++;
}

RIB_array *ArrayDup( RIB_array *ra )
{
	RIB_array *ret = new RIB_array;
	ret->element_size = ra->element_size;
	ret->allocated = ra->allocated;
	ret->nelems = ra->nelems;
	ret->array = new char[ra->nelems * ra->element_size];
	memcpy( ret->array, ra->array, ra->nelems * ra->element_size );
	return ret;
}

void ArrayFree( RIB_array *ra )
{
	delete [] ((char *) ra->array);
	delete ra;
}

static RtFloat * FindBasis( const char *str )
{
	/*
	if (!strcmp( str, "bezier" )) return (RtFloat *) RiBezierBasis;
	else if (!strcmp( str, "b-spline" )) return (RtFloat *) RiBSplineBasis;
	else if (!strcmp( str, "catmull-rom" )) return (RtFloat *) RiCatmullRomBasis;
	else if (!strcmp( str, "hermite" )) return (RtFloat *) RiHermiteBasis;
	else if (!strcmp( str, "power" )) return (RtFloat *) RiPowerBasis;
	else ParseError( "Unknown basis: %s", str );
	*/

	Warning("Named bases aren't supported yet...");

	return NULL;
}
static bool VerifyArrayLength( RIB_array *arr, RtInt required,
	const char *command ) {
	if (arr->nelems != required) {
		ParseError( "%s requires a(n) %d element array!", command, required);
		return false;
	}
	return true;
}

static RtInt *MakeIntArray( RIB_array *arr )
{
	RtInt *ret = new RtInt[arr->nelems];
	for (int i = 0 ; i < arr->nelems ; i++)
		ret[i] = RtInt(NA(arr)[i]);
	return ret;
}

static RtFilterFunc FindFilterFunc( const char *name )
{
	if (!strcmp( name, "box" ))
		return RiBoxFilter;
	else if (!strcmp( name, "triangle" ))
		return RiTriangleFilter;
	else if (!strcmp( name, "catmull-rom" ))
		return RiCatmullRomFilter;
	else if (!strcmp( name, "sinc" ))
		return RiSincFilter;
	else if (!strcmp( name, "gaussian" ))
		return RiGaussianFilter;
	else
		ParseError( "Unknown filter function :%s", name );
	return RtFilterFunc(NULL);
}

#line 133 "ribparse.y"
typedef union {
char string[1024];
RtFloat num;
RIB_array *ribarray;
} YYSTYPE;
#ifndef YYDEBUG
#define YYDEBUG 1
#endif

#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		418
#define	YYFLAG		-32768
#define	YYNTBASE	102

#define YYTRANSLATE(x) ((unsigned)(x) <= 355 ? yytranslate[x] : 123)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
    17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
    27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
    37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
    47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
    57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
    67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
    77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
    87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
    97,    98,    99,   100,   101
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     2,     3,     4,     5,     7,     9,    11,    13,    18,
    21,    24,    26,    29,    31,    33,    38,    41,    44,    46,
    49,    52,    53,    56,    57,    60,    63,    65,    68,    73,
    77,    81,    83,    85,    91,    97,   103,   109,   117,   120,
   124,   129,   132,   136,   142,   146,   149,   152,   158,   161,
   168,   172,   176,   180,   185,   188,   196,   199,   205,   208,
   214,   218,   222,   228,   232,   236,   241,   244,   247,   249,
   253,   257,   261,   265,   275,   279,   281,   285,   289,   293,
   298,   308,   322,   330,   335,   345,   348,   351,   353,   366,
   369,   371,   374,   379,   382,   386,   389,   396,   400,   404,
   412,   416,   420,   423,   428,   432,   435,   441,   446,   449,
   453,   460,   463,   465,   471,   476,   482,   485,   488,   491,
   495,   498,   507,   510,   513,   515,   522,   526,   530,   540,
   543,   551,   555,   558,   560,   562,   567,   578,   580
};

static const short yyrhs[] = {   121,
     0,     0,     0,     0,   107,     0,   112,     0,   108,     0,
   109,     0,   103,     6,   110,     7,     0,   103,   111,     0,
   110,   111,     0,   111,     0,   104,     3,     0,   113,     0,
   114,     0,   103,     6,   115,     7,     0,   103,   116,     0,
   115,   116,     0,   116,     0,   105,     5,     0,   118,   119,
     0,     0,   120,   119,     0,     0,     3,   106,     0,   121,
   122,     0,   122,     0,    98,     5,     0,     9,     3,     5,
   117,     0,    10,     3,   117,     0,    11,     3,   117,     0,
    12,     0,    13,     0,    14,     3,     5,     3,     5,     0,
    14,     3,     5,   113,     5,     0,    14,   113,     5,     3,
     5,     0,    14,   113,     5,   113,     5,     0,    15,     5,
     5,     5,     5,     5,     5,     0,    15,   113,     0,    16,
     5,     5,     0,    17,     5,     5,     5,     0,    17,   113,
     0,    18,   113,   113,     0,    20,     5,     5,     5,   117,
     0,    20,   113,   117,     0,    19,   112,     0,    21,     3,
     0,    22,     5,     5,     5,     5,     0,    22,   113,     0,
    23,     5,     5,     5,     5,   117,     0,    23,   113,   117,
     0,    24,     3,     3,     0,    25,     3,   117,     0,    26,
     5,     5,     5,     0,    26,     8,     0,    27,     5,     5,
     5,     5,     5,     5,     0,    27,   113,     0,    28,     5,
     5,     5,     5,     0,    28,   113,     0,    29,     5,     5,
     5,   117,     0,    29,   113,   117,     0,    30,     3,   117,
     0,    31,     3,     3,     3,   117,     0,    32,     5,     5,
     0,    33,     3,   117,     0,    34,     5,     5,     5,     0,
    35,     5,     0,    36,     5,     0,    37,     0,    38,   112,
   117,     0,    39,     3,     5,     0,    40,     3,   117,     0,
    41,     3,   117,     0,    42,     5,     5,     5,     5,     5,
     5,     5,   117,     0,    42,   113,   117,     0,    43,     0,
    44,     5,     5,     0,    45,     3,   117,     0,    46,     3,
   117,     0,    47,     3,     5,   117,     0,    48,     3,     3,
     3,     3,     3,     5,     5,   117,     0,    49,     3,     3,
     3,     3,     3,     3,     3,     5,     3,     5,     5,   117,
     0,    50,     3,     3,     3,     5,     5,   117,     0,    52,
     3,     3,   117,     0,    53,     3,     3,     3,     3,     3,
     5,     5,   117,     0,    54,     5,     0,    55,   112,     0,
    56,     0,    57,     5,     5,   113,     5,     5,     5,     5,
   113,     5,     5,   117,     0,    58,     5,     0,    59,     0,
    60,     5,     0,    61,     5,     5,     5,     0,    61,   113,
     0,    62,     3,   117,     0,    63,     3,     0,    64,     5,
     5,     5,     5,   117,     0,    64,   113,   117,     0,    65,
     3,   117,     0,    66,     3,     5,     3,     5,     3,   117,
     0,    67,     3,   117,     0,    51,     5,   117,     0,    68,
     5,     0,    69,     3,     5,     5,     0,    70,     5,     5,
     0,    71,     5,     0,    72,   112,   112,   112,   117,     0,
    73,   112,   112,   117,     0,    74,   117,     0,    75,     3,
   117,     0,    76,     3,     5,     5,     5,     5,     0,    77,
     5,     0,    78,     0,    79,     5,     5,     5,     5,     0,
    80,     5,     5,     5,     0,    81,     5,     5,     5,     5,
     0,    81,   113,     0,    82,     3,     0,    83,     5,     0,
    84,     5,     5,     0,    85,     5,     0,    86,     5,     5,
     5,     5,     5,     5,     5,     0,    86,   113,     0,    87,
     3,     0,    88,     0,    89,     5,     5,     5,     5,   117,
     0,    89,   113,   117,     0,    90,     3,   117,     0,    91,
     5,     5,     5,     5,     5,     5,     5,     5,     0,    91,
   113,     0,    92,     5,     5,     5,     5,     5,   117,     0,
    92,   113,   117,     0,    93,   113,     0,    94,     0,    95,
     0,    96,     5,     5,     5,     0,    97,   112,   112,   112,
   112,   112,   112,   112,   112,   112,     0,    99,     0,   100,
     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   169,   171,   180,   185,   190,   194,   199,   203,   208,   212,
   214,   215,   217,   223,   227,   232,   236,   238,   239,   241,
   247,   249,   254,   255,   257,   273,   274,   276,   277,   285,
   289,   293,   297,   301,   307,   315,   323,   330,   337,   343,
   347,   353,   359,   374,   378,   383,   389,   393,   397,   403,
   407,   413,   417,   421,   425,   429,   436,   442,   446,   452,
   456,   462,   466,   470,   474,   478,   482,   486,   490,   494,
   501,   505,   509,   513,   520,   530,   534,   547,   551,   555,
   563,   568,   574,   579,   583,   588,   592,   597,   601,   608,
   612,   616,   620,   626,   632,   636,   640,   644,   650,   654,
   658,   662,   666,   670,   675,   679,   683,   700,   720,   742,
   746,   750,   754,   758,   762,   766,   770,   776,   780,   784,
   788,   792,   796,   803,   807,   811,   815,   821,   825,   830,
   837,   841,   848,   854,   858,   862,   866,   889,   893
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","STRING",
"ID","NUM","LBRACK","RBRACK","DASH","AREALIGHTSOURCE","ATMOSPHERE","ATTRIBUTE",
"ATTRIBUTEBEGIN","ATTRIBUTEEND","BASIS","BOUND","CLIPPING","COLOR","COLORSAMPLES",
"CONCATTRANSFORM","CONE","COORDINATESYSTEM","CROPWINDOW","CYLINDER","DECLARE",
"DEFORMATION","DEPTHOFFIELD","DETAIL","DETAILRANGE","DISK","DISPLACEMENT","DISPLAY",
"EXPOSURE","EXTERIOR","FORMAT","FRAMEASPECTRATIO","FRAMEBEGIN","FRAMEEND","GENERALPOLYGON",
"GEOMETRICAPPROXIMATION","GEOMETRY","HIDER","HYPERBOLOID","IDENTITY","ILLUMINATE",
"IMAGER","INTERIOR","LIGHTSOURCE","MAKEBUMP","MAKECUBEFACEENVIRONMENT","MAKELATLONGENVIRONMENT",
"ILLUMINATIONMAP","MAKESHADOW","MAKETEXTURE","MATTE","MOTIONBEGIN","MOTIONEND",
"NUPATCH","OBJECTBEGIN","OBJECTEND","OBJECTINSTANCE","OPACITY","OPTION","ORIENTATION",
"PARABOLOID","PATCH","PATCHMESH","FASTLEVELSET","PERSPECTIVE","PIXELFILTER",
"PIXELSAMPLES","PIXELVARIANCE","POINTSGENERALPOLYGONS","POINTSPOLYGONS","POLYGON",
"PROJECTION","QUANTIZE","RELATIVEDETAIL","REVERSEORIENTATION","ROTATE","SCALE",
"SCREENWINDOW","SHADINGINTERPOLATION","SHADINGRATE","SHUTTER","SIDES","SKEW",
"SOLIDBEGIN","SOLIDEND","SPHERE","SURFACE","TEXTURECOORDINATES","TORUS","TRANSFORM",
"TRANSFORMBEGIN","TRANSFORMEND","TRANSLATE","TRIMCURVE","VERSION","WORLDBEGIN",
"WORLDEND","HIGH_PRECEDENCE","start","array_init","string_array_init","num_array_init",
"array","string_array","real_string_array","single_element_string_array","string_list",
"string_list_entry","num_array","real_num_array","single_element_num_array",
"num_list","num_list_entry","paramlist","paramlist_init","paramlist_contents",
"paramlist_entry","ri_stmt_list","ri_stmt", NULL
};
#endif

static const short yyr1[] = {     0,
   102,   103,   104,   105,   106,   106,   107,   107,   108,   109,
   110,   110,   111,   112,   112,   113,   114,   115,   115,   116,
   117,   118,   119,   119,   120,   121,   121,   122,   122,   122,
   122,   122,   122,   122,   122,   122,   122,   122,   122,   122,
   122,   122,   122,   122,   122,   122,   122,   122,   122,   122,
   122,   122,   122,   122,   122,   122,   122,   122,   122,   122,
   122,   122,   122,   122,   122,   122,   122,   122,   122,   122,
   122,   122,   122,   122,   122,   122,   122,   122,   122,   122,
   122,   122,   122,   122,   122,   122,   122,   122,   122,   122,
   122,   122,   122,   122,   122,   122,   122,   122,   122,   122,
   122,   122,   122,   122,   122,   122,   122,   122,   122,   122,
   122,   122,   122,   122,   122,   122,   122,   122,   122,   122,
   122,   122,   122,   122,   122,   122,   122,   122,   122,   122,
   122,   122,   122,   122,   122,   122,   122,   122,   122
};

static const short yyr2[] = {     0,
     1,     0,     0,     0,     1,     1,     1,     1,     4,     2,
     2,     1,     2,     1,     1,     4,     2,     2,     1,     2,
     2,     0,     2,     0,     2,     2,     1,     2,     4,     3,
     3,     1,     1,     5,     5,     5,     5,     7,     2,     3,
     4,     2,     3,     5,     3,     2,     2,     5,     2,     6,
     3,     3,     3,     4,     2,     7,     2,     5,     2,     5,
     3,     3,     5,     3,     3,     4,     2,     2,     1,     3,
     3,     3,     3,     9,     3,     1,     3,     3,     3,     4,
     9,    13,     7,     4,     9,     2,     2,     1,    12,     2,
     1,     2,     4,     2,     3,     2,     6,     3,     3,     7,
     3,     3,     2,     4,     3,     2,     5,     4,     2,     3,
     6,     2,     1,     5,     4,     5,     2,     2,     2,     3,
     2,     8,     2,     2,     1,     6,     3,     3,     9,     2,
     7,     3,     2,     1,     1,     4,    10,     1,     1
};

static const short yydefact[] = {     0,
     0,     0,     0,    32,    33,     2,     2,     0,     2,     2,
     2,     2,     0,     2,     2,     0,     0,     0,     2,     2,
     2,     0,     0,     0,     0,     0,     0,     0,    69,     2,
     0,     0,     0,     2,    76,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     2,    88,     0,     0,
    91,     0,     2,     0,     0,     2,     0,     0,     0,     0,
     0,     0,     0,     2,     2,    22,     0,     0,     0,   113,
     0,     0,     2,     0,     0,     0,     0,     2,     0,   125,
     2,     0,     2,     2,     2,   134,   135,     0,     2,     0,
   138,   139,     1,    27,     0,    22,    22,     0,     0,     0,
     0,    39,     0,     0,    42,     2,     4,    46,    14,    15,
     0,    22,    47,     0,    49,     0,    22,     0,    22,     0,
    55,     0,    57,     0,    59,     0,    22,    22,     0,     0,
    22,     0,    67,    68,    22,     0,    22,    22,     0,    22,
     0,    22,    22,     0,     0,     0,     0,    22,     0,     0,
    86,    87,     0,    90,    92,     0,    94,    22,    96,     0,
    22,    22,     0,    22,   103,     0,     0,   106,     2,     2,
   109,    24,    22,     0,   112,     0,     0,     0,   117,   118,
   119,     0,   121,     0,   123,   124,     0,    22,    22,     0,
   130,     0,    22,   133,     0,     2,    28,    26,    22,    30,
    31,     2,     4,     2,     0,    40,     0,    43,     0,    17,
     0,    45,     0,     0,    51,    52,    53,     0,     0,     0,
     0,    61,    62,     0,    64,    65,     0,    70,    71,    72,
    73,     0,    75,    77,    78,    79,    22,     0,     0,     0,
   102,    22,     0,     2,     0,    95,     0,    98,    99,     0,
   101,     0,   105,     2,    22,     2,    21,    24,   110,     0,
     0,     0,     0,   120,     0,     0,   127,   128,     0,     0,
   132,     0,     2,    29,     0,     0,     4,    19,     0,     0,
     0,    41,    20,    22,     0,     0,    54,     0,     0,    22,
    22,    66,     0,    80,     0,     0,     0,    84,     0,     0,
    93,     0,     0,   104,    22,   108,     3,    25,     5,     7,
     8,     6,    23,     0,     0,   115,     0,     0,     0,     0,
     0,   136,     2,    34,    35,    16,    18,    36,    37,     0,
    44,    48,    22,     0,    58,    60,    63,     0,     0,     0,
     0,     0,     0,    22,     0,   107,     3,     0,    10,     0,
   114,   116,     0,    22,     0,     0,     2,     0,    50,     0,
     0,     0,     0,    22,     0,     0,    97,    22,     3,    12,
    13,   111,     0,   126,     0,    22,     2,    38,    56,     0,
     0,     0,    83,     0,     0,   100,     9,    11,     0,     0,
   131,     2,    22,    22,     0,    22,     2,   122,     0,     2,
    74,    81,     0,    85,     0,   129,     2,     0,     0,   137,
     0,    22,    22,    89,    82,     0,     0,     0
};

static const short yydefgoto[] = {   416,
    99,   348,   209,   308,   309,   310,   311,   369,   349,   108,
   109,   110,   277,   210,   171,   172,   257,   258,    93,    94
};

static const short yypact[] = {   419,
     1,    11,    17,-32768,-32768,    19,    20,    21,    22,-32768,
-32768,    23,    26,    27,    28,    31,    32,    13,    33,    34,
    35,    40,    41,    42,    43,    45,    46,    50,-32768,-32768,
    53,    54,    55,    56,-32768,    57,    60,    61,    62,    64,
    65,    67,    66,    69,    70,    71,-32768,-32768,    77,    79,
-32768,    80,    81,    72,    84,    83,    86,    87,    88,    89,
    90,    91,    92,-32768,-32768,-32768,    95,    96,    98,-32768,
    99,   100,   101,    97,   102,   103,   104,   107,   110,-32768,
   109,   112,   111,   113,-32768,-32768,-32768,   114,-32768,   115,
-32768,-32768,   419,-32768,   116,-32768,-32768,   117,    25,   118,
   119,-32768,   120,   122,-32768,-32768,    25,-32768,-32768,-32768,
   123,-32768,-32768,   124,-32768,   125,-32768,   129,-32768,   130,
-32768,   131,-32768,   132,-32768,   133,-32768,-32768,   136,   135,
-32768,   138,-32768,-32768,-32768,   139,-32768,-32768,   143,-32768,
   145,-32768,-32768,   150,   157,   158,   160,-32768,   161,   162,
-32768,-32768,   163,-32768,-32768,   164,-32768,-32768,-32768,   165,
-32768,-32768,   166,-32768,-32768,   169,   172,-32768,-32768,-32768,
-32768,   176,-32768,   175,-32768,   177,   178,   179,-32768,-32768,
-32768,   181,-32768,   183,-32768,-32768,   184,-32768,-32768,   185,
-32768,   186,-32768,-32768,   187,-32768,-32768,-32768,-32768,-32768,
-32768,   190,-32768,   191,   192,-32768,   194,-32768,   196,-32768,
   199,-32768,   200,   201,-32768,-32768,-32768,   203,   204,   205,
   206,-32768,-32768,   193,-32768,-32768,   207,-32768,-32768,-32768,
-32768,   209,-32768,-32768,-32768,-32768,-32768,   212,   213,   214,
-32768,-32768,   215,-32768,   216,-32768,   217,-32768,-32768,   220,
-32768,   219,-32768,-32768,-32768,-32768,-32768,   176,-32768,   221,
   222,   223,   224,-32768,   225,   227,-32768,-32768,   229,   230,
-32768,   231,-32768,-32768,   232,   233,    30,-32768,   234,   236,
   237,-32768,-32768,-32768,   239,   241,-32768,   242,   243,-32768,
-32768,-32768,   244,-32768,   249,   250,   252,-32768,   251,   253,
-32768,   254,   255,-32768,-32768,-32768,     7,-32768,-32768,-32768,
-32768,-32768,-32768,   256,   258,-32768,   259,   260,   261,   262,
   263,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,   265,
-32768,-32768,-32768,   266,-32768,-32768,-32768,   267,   270,   271,
   272,   273,   274,-32768,   275,-32768,   276,   277,-32768,   278,
-32768,-32768,   279,-32768,   280,   281,-32768,   282,-32768,   283,
   284,   285,   288,-32768,   287,   289,-32768,-32768,    38,-32768,
-32768,-32768,   290,-32768,   291,-32768,-32768,-32768,-32768,   292,
   294,   298,-32768,   297,   301,-32768,-32768,-32768,   302,   303,
-32768,-32768,-32768,-32768,   304,-32768,-32768,-32768,   305,-32768,
-32768,-32768,   300,-32768,   306,-32768,-32768,   308,   309,-32768,
   310,-32768,-32768,-32768,-32768,    48,    59,-32768
};

static const short yypgoto[] = {-32768,
   -11,-32768,-32768,-32768,-32768,-32768,-32768,-32768,  -346,   -23,
    -4,-32768,-32768,  -194,    14,-32768,  -198,-32768,-32768,    -1
};


#define	YYLAST		519


static const short yytable[] = {   107,
   370,   100,   102,    95,   105,   106,   135,   112,   278,   115,
   117,    -4,   347,    96,   123,   125,   127,   120,   107,    97,
   121,    98,   388,   152,   101,   103,   104,   111,   113,   140,
   203,   114,   116,   118,   119,   107,   326,   122,   124,   126,
   169,   170,   128,   129,   387,   131,   130,   417,   157,   132,
   133,   161,   107,   107,   134,   136,   137,   138,   418,   313,
   139,   141,   142,   143,   144,   196,   145,   146,   179,   147,
   148,   149,   150,   185,   158,   151,   188,   107,   191,   193,
   194,   153,   327,   154,   155,   156,   159,   160,   162,   163,
   164,   198,   166,   165,     0,   167,   168,   173,   174,   180,
     0,   208,   175,   176,   177,   178,   181,   182,   183,   200,
   201,   184,   186,   187,   189,   190,     0,   192,   195,   197,
   199,   202,   204,   205,   206,   212,   207,   211,   213,   214,
   215,   216,   217,     0,   218,   219,   220,   221,   224,   225,
   222,   223,   227,   229,   226,   254,   255,   232,   228,   234,
   230,   231,   278,   233,   237,   235,   236,   107,   107,   238,
   239,   241,   240,   242,   243,     0,     0,   244,   245,   247,
   250,   246,   273,   252,   248,   249,   253,   251,   256,   260,
     0,   261,   262,   263,   107,   264,   259,   265,   266,   269,
   270,   272,   275,   279,     0,   291,   281,   276,   282,   280,
   283,   267,   268,   284,   285,   286,   271,   287,   288,   289,
   290,   292,   274,   293,   295,   296,   297,   299,     0,     0,
   301,   302,   303,   304,     0,   314,   315,   316,   317,   318,
   305,   319,   312,   320,   321,   322,   324,   325,   328,   300,
   329,   330,   107,   332,   307,   333,   334,   335,   338,   323,
   294,   339,   340,   342,     0,   298,   341,   343,   344,   345,
   350,   107,   351,   352,   353,   354,   355,   356,   306,   358,
   360,   361,   362,   363,     0,   365,   364,   368,   366,   371,
    -4,     0,   372,   373,   375,   376,   378,   379,   380,   381,
   382,   384,     0,   385,   389,   390,   393,   331,   394,   357,
   395,   396,   408,   336,   337,   397,   398,   399,   403,   406,
   409,   107,   411,   412,   413,     0,     0,     0,   346,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   377,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   107,   359,     0,     0,     0,
     0,     0,     0,   392,     0,     0,     0,   367,     0,     0,
     0,     0,     0,     0,     0,   107,     0,   374,   400,     0,
     0,     0,     0,     0,     0,     0,   407,   383,     0,     0,
   107,   386,     0,   410,     0,     0,     0,     0,   107,   391,
     0,     0,   405,     0,     0,   107,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   401,   402,     0,   404,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   414,   415,     1,     2,     3,
     4,     5,     6,     7,     8,     9,    10,    11,    12,    13,
    14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
    24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
    34,    35,    36,    37,    38,    39,    40,    41,    42,    43,
    44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
    54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
    64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
    74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
    84,    85,    86,    87,    88,    89,    90,    91,    92
};

static const short yycheck[] = {    11,
   347,     6,     7,     3,     9,    10,    30,    12,   203,    14,
    15,     5,     6,     3,    19,    20,    21,     5,    30,     3,
     8,     3,   369,    47,     5,     5,     5,     5,     3,    34,
     6,     5,     5,     3,     3,    47,     7,     5,     5,     5,
    64,    65,     3,     3,     7,     3,     5,     0,    53,     5,
     5,    56,    64,    65,     5,     3,     3,     3,     0,   258,
     5,     5,     3,     3,     3,    89,     3,     3,    73,     3,
     5,     3,     3,    78,     3,     5,    81,    89,    83,    84,
    85,     5,   277,     5,     5,     5,     3,     5,     3,     3,
     3,    93,     3,     5,    -1,     5,     5,     3,     3,     3,
    -1,   106,     5,     5,     5,     5,     5,     5,     5,    96,
    97,     5,     3,     5,     3,     5,    -1,     5,     5,     5,
     5,     5,     5,     5,     5,   112,     5,     5,     5,     5,
   117,     3,   119,    -1,     5,     5,     5,     5,     3,     5,
   127,   128,     5,     5,   131,   169,   170,     5,   135,     5,
   137,   138,   347,   140,     5,   142,   143,   169,   170,     3,
     3,   148,     3,     3,     3,    -1,    -1,     5,     5,     5,
     5,   158,   196,     5,   161,   162,     5,   164,     3,     5,
    -1,     5,     5,     5,   196,     5,   173,     5,     5,     5,
     5,     5,     3,     3,    -1,     3,     5,   202,     5,   204,
     5,   188,   189,     5,     5,     5,   193,     5,     5,     5,
     5,     5,   199,     5,     3,     3,     3,     3,    -1,    -1,
     5,     5,     3,     5,    -1,     5,     5,     5,     5,     5,
   254,     5,   256,     5,     5,     5,     5,     5,     5,   244,
     5,     5,   254,     5,   256,     5,     5,     5,     5,   273,
   237,     3,     3,     3,    -1,   242,     5,     5,     5,     5,
     5,   273,     5,     5,     5,     5,     5,     5,   255,     5,
     5,     5,     3,     3,    -1,     3,     5,     3,     5,     3,
     5,    -1,     5,     5,     5,     5,     5,     5,     5,     5,
     3,     5,    -1,     5,     5,     5,     5,   284,     5,   323,
     3,     5,     3,   290,   291,     5,     5,     5,     5,     5,
     5,   323,     5,     5,     5,    -1,    -1,    -1,   305,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,   357,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,   357,   333,    -1,    -1,    -1,
    -1,    -1,    -1,   377,    -1,    -1,    -1,   344,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,   377,    -1,   354,   392,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,   400,   364,    -1,    -1,
   392,   368,    -1,   407,    -1,    -1,    -1,    -1,   400,   376,
    -1,    -1,   397,    -1,    -1,   407,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,   393,   394,    -1,   396,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,   412,   413,     9,    10,    11,
    12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
    22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
    32,    33,    34,    35,    36,    37,    38,    39,    40,    41,
    42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
    52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
    62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
    72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
    82,    83,    84,    85,    86,    87,    88,    89,    90,    91,
    92,    93,    94,    95,    96,    97,    98,    99,   100
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/local/share/bison.simple"
/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 217 "/usr/local/share/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 2:
#line 172 "ribparse.y"
{
	if (cur_array) ArrayFree( cur_array );
	cur_array = new RIB_array;
	cur_array->allocated = 0;
	cur_array->nelems = 0;
	cur_array->array = NULL;
;
    break;}
case 3:
#line 181 "ribparse.y"
{
	cur_array->element_size = sizeof( const char * );
;
    break;}
case 4:
#line 186 "ribparse.y"
{
	cur_array->element_size = sizeof( RtFloat );
;
    break;}
case 5:
#line 191 "ribparse.y"
{
	yyval.ribarray = yyvsp[0].ribarray;
;
    break;}
case 6:
#line 195 "ribparse.y"
{
	yyval.ribarray = yyvsp[0].ribarray;
;
    break;}
case 7:
#line 200 "ribparse.y"
{
	yyval.ribarray = yyvsp[0].ribarray;
;
    break;}
case 8:
#line 204 "ribparse.y"
{
	yyval.ribarray = ArrayDup(cur_array);
;
    break;}
case 9:
#line 209 "ribparse.y"
{
	yyval.ribarray = ArrayDup(cur_array);
;
    break;}
case 13:
#line 218 "ribparse.y"
{
	char *to_add = strdup(yyvsp[0].string);
	AddArrayElement( &to_add );
;
    break;}
case 14:
#line 224 "ribparse.y"
{
	yyval.ribarray = yyvsp[0].ribarray;
;
    break;}
case 15:
#line 228 "ribparse.y"
{
	yyval.ribarray = ArrayDup(cur_array);
;
    break;}
case 16:
#line 233 "ribparse.y"
{
	yyval.ribarray = ArrayDup(cur_array);
;
    break;}
case 20:
#line 242 "ribparse.y"
{
	RtFloat to_add = yyvsp[0].num;
	AddArrayElement( &to_add );
;
    break;}
case 22:
#line 250 "ribparse.y"
{
	cur_paramlist_size = 0;
;
    break;}
case 25:
#line 258 "ribparse.y"
{
	RtPointer arg = new char[ yyvsp[0].ribarray->nelems * yyvsp[0].ribarray->element_size ];
	memcpy( arg, yyvsp[0].ribarray->array, yyvsp[0].ribarray->nelems * yyvsp[0].ribarray->element_size );
	if (cur_paramlist_size >= cur_paramlist_allocated) {
		cur_paramlist_allocated = 2*cur_paramlist_allocated + 1;
		cur_paramlist_tokens = (RtToken *) realloc( cur_paramlist_tokens, cur_paramlist_allocated*sizeof(RtToken) );
		cur_paramlist_args = (RtPointer *) realloc( cur_paramlist_args, cur_paramlist_allocated*sizeof(RtPointer) );
		cur_paramlist_sizes = (RtInt *) realloc( cur_paramlist_sizes, cur_paramlist_allocated*sizeof(RtInt) );
	}
	cur_paramlist_tokens[cur_paramlist_size] = yyvsp[-1].string;
	cur_paramlist_sizes[cur_paramlist_size] = yyvsp[0].ribarray->nelems;
	cur_paramlist_args[cur_paramlist_size++] = arg;
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 28:
#line 276 "ribparse.y"
{ printf ("RIB Version: %f\n", yyvsp[0].num ); ;
    break;}
case 29:
#line 278 "ribparse.y"
{
    int num = (int)yyvsp[-1].num;
	if (num < 0 || num >= MAX_LIGHT_HANDLE)
		Error("Invalid light handle %d passed to AreaLightSource. Ignoring.", num);
	else
		lights[num] = RiAreaLightSourceV( yyvsp[-2].string, CPS, CPT, CPA );
;
    break;}
case 30:
#line 286 "ribparse.y"
{
	RiAtmosphereV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 31:
#line 290 "ribparse.y"
{
	RiAttributeV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 32:
#line 294 "ribparse.y"
{
	RiAttributeBegin();
;
    break;}
case 33:
#line 298 "ribparse.y"
{
	RiAttributeEnd();
;
    break;}
case 34:
#line 302 "ribparse.y"
{
	RtFloat * basis1 = FindBasis( yyvsp[-3].string );
	RtFloat * basis2 = FindBasis( yyvsp[-1].string );
	RiBasis( basis1, RtInt(yyvsp[-2].num), basis2, RtInt(yyvsp[0].num) );
;
    break;}
case 35:
#line 308 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[-1].ribarray, 16, "Basis" )) {
		RtFloat * basis1 = FindBasis( yyvsp[-3].string );
		RiBasis( basis1, RtInt(yyvsp[-2].num), (RtFloat *) yyvsp[-1].ribarray->array, RtInt(yyvsp[0].num) );
	}
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 36:
#line 316 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[-3].ribarray, 16, "Basis" )) {
		RtFloat * basis2 = FindBasis( yyvsp[-1].string );
		RiBasis( (RtFloat *) yyvsp[-3].ribarray->array, RtInt(yyvsp[-2].num), basis2, RtInt(yyvsp[0].num) );
	}
	ArrayFree( yyvsp[-3].ribarray );
;
    break;}
case 37:
#line 324 "ribparse.y"
{
	if (VerifyArrayLength(yyvsp[-3].ribarray, 16, "Basis") && VerifyArrayLength(yyvsp[-1].ribarray, 16, "Basis"))
		RiBasis( (RtFloat *) yyvsp[-3].ribarray->array, RtInt(yyvsp[-2].num), (RtFloat *) yyvsp[-1].ribarray->array, RtInt(yyvsp[0].num) );
	ArrayFree( yyvsp[-3].ribarray );
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 38:
#line 331 "ribparse.y"
{
	RtBound bound;
	bound[0] = yyvsp[-5].num; bound[1] = yyvsp[-4].num; bound[2] = yyvsp[-3].num;
	bound[3] = yyvsp[-2].num; bound[4] = yyvsp[-1].num; bound[5] = yyvsp[0].num;
	RiBound( bound );
;
    break;}
case 39:
#line 338 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 6, "Bound" ))
		RiBound( (RtFloat *) yyvsp[0].ribarray->array );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 40:
#line 344 "ribparse.y"
{
	RiClipping( yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 41:
#line 348 "ribparse.y"
{
	RtBound color;
	color[0] = yyvsp[-2].num; color[1] = yyvsp[-1].num; color[2] = yyvsp[0].num;
	RiColor( color );
;
    break;}
case 42:
#line 354 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 3, "Color" ));
		RiColor( (RtFloat *) yyvsp[0].ribarray->array );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 43:
#line 360 "ribparse.y"
{
	if (yyvsp[-1].ribarray->nelems != yyvsp[0].ribarray->nelems) {
		ParseError( "The two arrays should be the same size in ColorSamples" );
		goto noGoodColor;
	}
	if (yyvsp[-1].ribarray->nelems % 3 != 0) {
		ParseError( "The two arrays should be the multiples of 3 in ColorSamples" );
		goto noGoodColor;
	}
	RiColorSamples( yyvsp[-1].ribarray->nelems / 3, NA(yyvsp[-1].ribarray), NA(yyvsp[0].ribarray) );
noGoodColor:
	ArrayFree( yyvsp[-1].ribarray );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 44:
#line 375 "ribparse.y"
{
	RiConeV( yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 45:
#line 379 "ribparse.y"
{
	VerifyArrayLength( yyvsp[-1].ribarray, 3, "Cone" );
	RiConeV( NA(yyvsp[-1].ribarray)[0], NA(yyvsp[-1].ribarray)[1], NA(yyvsp[-1].ribarray)[2], CPS, CPT, CPA );
;
    break;}
case 46:
#line 384 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 16, "ConcatTransform" ));
		RiConcatTransform( (RtFloat *) yyvsp[0].ribarray->array );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 47:
#line 390 "ribparse.y"
{
	RiCoordinateSystem( yyvsp[0].string );
;
    break;}
case 48:
#line 394 "ribparse.y"
{
	RiCropWindow( yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 49:
#line 398 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 4, "CropWindow" ))
		RiCropWindow( NA(yyvsp[0].ribarray)[0], NA(yyvsp[0].ribarray)[1], NA(yyvsp[0].ribarray)[2], NA(yyvsp[0].ribarray)[3] );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 50:
#line 404 "ribparse.y"
{
	RiCylinderV( yyvsp[-4].num, yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 51:
#line 408 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[-1].ribarray, 4, "Cylinder" ))
		RiCylinderV( NA(yyvsp[-1].ribarray)[0], NA(yyvsp[-1].ribarray)[1], NA(yyvsp[-1].ribarray)[2], NA(yyvsp[-1].ribarray)[3], CPS, CPT, CPA );
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 52:
#line 414 "ribparse.y"
{
	RiDeclare( yyvsp[-1].string, yyvsp[0].string );
;
    break;}
case 53:
#line 418 "ribparse.y"
{
	RiDeformationV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 54:
#line 422 "ribparse.y"
{
	RiDepthOfField( yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 55:
#line 426 "ribparse.y"
{
	RiDepthOfField( RI_INFINITY, 0, 0 );
;
    break;}
case 56:
#line 430 "ribparse.y"
{
	RtBound bound;
	bound[0] = yyvsp[-5].num; bound[1] = yyvsp[-4].num; bound[2] = yyvsp[-3].num;
	bound[3] = yyvsp[-2].num; bound[4] = yyvsp[-1].num; bound[5] = yyvsp[0].num;
	RiDetail( bound );
;
    break;}
case 57:
#line 437 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 6, "Detail" ))
		RiDetail( (RtFloat *) yyvsp[0].ribarray->array );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 58:
#line 443 "ribparse.y"
{
	RiDetailRange( yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 59:
#line 447 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 4, "DetailRange" ))
		RiDetailRange( NA(yyvsp[0].ribarray)[0], NA(yyvsp[0].ribarray)[1], NA(yyvsp[0].ribarray)[2], NA(yyvsp[0].ribarray)[3] );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 60:
#line 453 "ribparse.y"
{
	RiDiskV( yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 61:
#line 457 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[-1].ribarray, 3, "Disk" ))
		RiDiskV( NA(yyvsp[-1].ribarray)[0], NA(yyvsp[-1].ribarray)[1], NA(yyvsp[-1].ribarray)[2], CPS, CPT, CPA );
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 62:
#line 463 "ribparse.y"
{
	RiDisplacementV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 63:
#line 467 "ribparse.y"
{
	RiDisplayV( yyvsp[-3].string, yyvsp[-2].string, yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 64:
#line 471 "ribparse.y"
{
	RiExposure( yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 65:
#line 475 "ribparse.y"
{
	RiExteriorV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 66:
#line 479 "ribparse.y"
{
	RiFormat( RtInt(yyvsp[-2].num), RtInt(yyvsp[-1].num), yyvsp[0].num );
;
    break;}
case 67:
#line 483 "ribparse.y"
{
	RiFrameAspectRatio( yyvsp[0].num );
;
    break;}
case 68:
#line 487 "ribparse.y"
{
	RiFrameBegin( RtInt(yyvsp[0].num) );
;
    break;}
case 69:
#line 491 "ribparse.y"
{
	RiFrameEnd();
;
    break;}
case 70:
#line 495 "ribparse.y"
{
	RtInt *verts = MakeIntArray( yyvsp[-1].ribarray );
	RiGeneralPolygonV( yyvsp[-1].ribarray->nelems, verts, CPS, CPT, CPA );
	delete [] verts;
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 71:
#line 502 "ribparse.y"
{
	RiGeometricApproximation( yyvsp[-1].string, yyvsp[0].num );
;
    break;}
case 72:
#line 506 "ribparse.y"
{
	RiGeometryV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 73:
#line 510 "ribparse.y"
{
	RiHiderV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 74:
#line 514 "ribparse.y"
{
	RtPoint point1, point2;
	point1[0] = yyvsp[-7].num; point1[1] = yyvsp[-6].num; point1[2] = yyvsp[-5].num;
	point2[0] = yyvsp[-4].num; point2[1] = yyvsp[-3].num; point2[2] = yyvsp[-2].num;
	RiHyperboloidV( point1, point2, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 75:
#line 521 "ribparse.y"
{
	RtBound point1, point2;
	if (VerifyArrayLength( yyvsp[-1].ribarray, 7, "Hyperboloid" )) {
		point1[0] = NA(yyvsp[-1].ribarray)[0]; point1[1] = NA(yyvsp[-1].ribarray)[1]; point1[2] = NA(yyvsp[-1].ribarray)[2];
		point2[0] = NA(yyvsp[-1].ribarray)[3]; point2[1] = NA(yyvsp[-1].ribarray)[4]; point2[2] = NA(yyvsp[-1].ribarray)[5];
		RiHyperboloidV( point1, point2, NA(yyvsp[-1].ribarray)[6], CPS, CPT, CPA );
	}
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 76:
#line 531 "ribparse.y"
{
	RiIdentity();
;
    break;}
case 77:
#line 535 "ribparse.y"
{
    int num = (int)yyvsp[-1].num;
	if (num < 0 || num >= MAX_LIGHT_HANDLE)
		Error("Invalid light handle %d passed to Illuminate. Ignoring.", num);
	else {
		RtLightHandle light = lights[num];
		if (light == (RtLightHandle)RI_NULL)
			ParseError( "Unknown light number: %d", num);
		else
			RiIlluminate( light, (RtBoolean) yyvsp[0].num );
	}
;
    break;}
case 78:
#line 548 "ribparse.y"
{
	RiImagerV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 79:
#line 552 "ribparse.y"
{
	RiInteriorV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 80:
#line 556 "ribparse.y"
{
    int num = (int)yyvsp[-1].num;
	if (num < 0 || num >= MAX_LIGHT_HANDLE)
		Error("Invalid light handle %d passed to LightSource. Ignoring.", num);
	else
		lights[num] = RiLightSourceV( yyvsp[-2].string, CPS, CPT, CPA );
;
    break;}
case 81:
#line 564 "ribparse.y"
{
	RtFilterFunc filterfunc = FindFilterFunc( yyvsp[-3].string );
	RiMakeBumpV( yyvsp[-7].string, yyvsp[-6].string, yyvsp[-5].string, yyvsp[-4].string, filterfunc, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 82:
#line 569 "ribparse.y"
{
	RtFilterFunc filterfunc = FindFilterFunc( yyvsp[-3].string );
	RiMakeCubeFaceEnvironmentV( yyvsp[-11].string, yyvsp[-10].string, yyvsp[-9].string, yyvsp[-8].string, yyvsp[-7].string, yyvsp[-6].string, yyvsp[-5].string, yyvsp[-4].num, filterfunc,
		yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 83:
#line 575 "ribparse.y"
{
	RtFilterFunc filterfunc = FindFilterFunc( yyvsp[-3].string );
	RiMakeLatLongEnvironmentV( yyvsp[-5].string, yyvsp[-4].string, filterfunc, yyvsp[-2].num, yyvsp[-2].num, CPS, CPT, CPA );
;
    break;}
case 84:
#line 580 "ribparse.y"
{
	RiMakeShadowV( yyvsp[-2].string, yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 85:
#line 584 "ribparse.y"
{
	RtFilterFunc filterfunc = FindFilterFunc( yyvsp[-3].string );
	RiMakeTextureV( yyvsp[-7].string, yyvsp[-6].string, yyvsp[-5].string, yyvsp[-4].string, filterfunc, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 86:
#line 589 "ribparse.y"
{
	RiMatte( yyvsp[0].num != 0. );
;
    break;}
case 87:
#line 593 "ribparse.y"
{
	RiMotionBeginV( yyvsp[0].ribarray->nelems, NA(yyvsp[0].ribarray) );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 88:
#line 598 "ribparse.y"
{
	RiMotionEnd();
;
    break;}
case 89:
#line 602 "ribparse.y"
{
	RiNuPatchV( RtInt(yyvsp[-10].num), RtInt(yyvsp[-9].num), NA(yyvsp[-8].ribarray), yyvsp[-7].num, yyvsp[-6].num,
				RtInt(yyvsp[-5].num), RtInt(yyvsp[-4].num), NA(yyvsp[-3].ribarray), yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
	ArrayFree(yyvsp[-8].ribarray);
	ArrayFree(yyvsp[-3].ribarray);
;
    break;}
case 90:
#line 609 "ribparse.y"
{
	Warning( "Don't know how to parse ObjectInstance" );
;
    break;}
case 91:
#line 613 "ribparse.y"
{
	RiObjectEnd();
;
    break;}
case 92:
#line 617 "ribparse.y"
{
	Warning( "Don't know how to parse ObjectInstance" );
;
    break;}
case 93:
#line 621 "ribparse.y"
{
	RtColor color;
	color[0] = yyvsp[-2].num; color[1] = yyvsp[-1].num; color[2] = yyvsp[0].num;
	RiOpacity( color );
;
    break;}
case 94:
#line 627 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 3, "Opacity" ))
		RiOpacity( (RtFloat *) yyvsp[0].ribarray->array );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 95:
#line 633 "ribparse.y"
{
	RiOptionV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 96:
#line 637 "ribparse.y"
{
	RiOrientation( yyvsp[0].string );
;
    break;}
case 97:
#line 641 "ribparse.y"
{
	RiParaboloidV( yyvsp[-4].num, yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 98:
#line 645 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[-1].ribarray, 4, "Paraboloid" ))
		RiParaboloidV( NA(yyvsp[-1].ribarray)[0], NA(yyvsp[-1].ribarray)[1], NA(yyvsp[-1].ribarray)[2], NA(yyvsp[-1].ribarray)[3], CPS, CPT, CPA );
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 99:
#line 651 "ribparse.y"
{
	RiPatchV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 100:
#line 655 "ribparse.y"
{
	RiPatchMeshV( yyvsp[-5].string, RtInt(yyvsp[-4].num), yyvsp[-3].string, RtInt(yyvsp[-2].num), yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 101:
#line 659 "ribparse.y"
{
	RiFastLevelSetV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 102:
#line 663 "ribparse.y"
{
	RiIlluminationMapV( RtFloat(yyvsp[-1].num), CPS, CPT, CPA );
;
    break;}
case 103:
#line 667 "ribparse.y"
{
	RiPerspective( yyvsp[0].num );
;
    break;}
case 104:
#line 671 "ribparse.y"
{
	RtFilterFunc func = FindFilterFunc( yyvsp[-2].string );
	RiPixelFilter( func, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 105:
#line 676 "ribparse.y"
{
	RiPixelSamples( yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 106:
#line 680 "ribparse.y"
{
	RiPixelVariance( yyvsp[0].num );
;
    break;}
case 107:
#line 684 "ribparse.y"
{
	RtInt *nloops, *nvertices, *vertices;

	nloops = MakeIntArray( yyvsp[-3].ribarray );
	nvertices = MakeIntArray( yyvsp[-2].ribarray );
	vertices = MakeIntArray( yyvsp[-1].ribarray );

	RiPointsGeneralPolygonsV( yyvsp[-3].ribarray->nelems, nloops, nvertices, vertices, CPS, CPT, CPA );

	delete [] nloops;
	delete [] nvertices;
	delete [] vertices;
	ArrayFree( yyvsp[-3].ribarray );
	ArrayFree( yyvsp[-2].ribarray );
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 108:
#line 701 "ribparse.y"
{
	// Gotta convert these bad boys to arrays of integers.  that sucks.
	RtInt *nverts, *verts;

	nverts = MakeIntArray( yyvsp[-2].ribarray );
	verts = MakeIntArray( yyvsp[-1].ribarray );
	int tot = 0;
	for (int i = 0 ; i < yyvsp[-2].ribarray->nelems ; i++)
		tot += nverts[i];
	if (tot != yyvsp[-1].ribarray->nelems)
		ParseError("Wrong number of vertex elements in PointsPolygons. Ignoring.");
	else
		RiPointsPolygonsV( yyvsp[-2].ribarray->nelems, nverts, verts, CPS, CPT, CPA );

	delete [] nverts;
	delete [] verts;
	ArrayFree( yyvsp[-2].ribarray );
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 109:
#line 721 "ribparse.y"
{
	RtInt num_verts = -1;

	for (int i = 0 ; i < CPS ; i++) {
		if (CPT[i] == RI_P || strcmp(CPT[i], RI_P) == 0) {
			num_verts = CPSZ[i];
			if (num_verts % 3 != 0) {
				ParseError( "RI_P array must be 3*n in length." );
				goto noGoodPolygon;
			}
			num_verts /= 3;
			break;
		}
	}
	if (num_verts == -1)
		ParseError( "Polygon without an RI_P parameter???" );
	else
		RiPolygonV( num_verts, CPS, CPT, CPA );
noGoodPolygon:
	;
;
    break;}
case 110:
#line 743 "ribparse.y"
{
	RiProjectionV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 111:
#line 747 "ribparse.y"
{
	RiQuantize( yyvsp[-4].string, RtInt(yyvsp[-3].num), RtInt(yyvsp[-2].num), RtInt(yyvsp[-1].num), yyvsp[0].num );
;
    break;}
case 112:
#line 751 "ribparse.y"
{
	RiRelativeDetail( yyvsp[0].num );
;
    break;}
case 113:
#line 755 "ribparse.y"
{
	RiReverseOrientation();
;
    break;}
case 114:
#line 759 "ribparse.y"
{
	RiRotate( yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 115:
#line 763 "ribparse.y"
{
	RiScale( yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 116:
#line 767 "ribparse.y"
{
	RiScreenWindow( yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 117:
#line 771 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 4, "ScreenWindow" ))
		RiScreenWindow( NA(yyvsp[0].ribarray)[0], NA(yyvsp[0].ribarray)[1], NA(yyvsp[0].ribarray)[2], NA(yyvsp[0].ribarray)[3] );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 118:
#line 777 "ribparse.y"
{
	RiShadingInterpolation( yyvsp[0].string );
;
    break;}
case 119:
#line 781 "ribparse.y"
{
	RiShadingRate( yyvsp[0].num );
;
    break;}
case 120:
#line 785 "ribparse.y"
{
	RiShutter( yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 121:
#line 789 "ribparse.y"
{
	RiSides( RtInt(yyvsp[0].num) );
;
    break;}
case 122:
#line 793 "ribparse.y"
{
	RiSkew( yyvsp[-6].num, yyvsp[-5].num, yyvsp[-4].num, yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 123:
#line 797 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 7, "Skew" ))
		RiSkew( NA(yyvsp[0].ribarray)[0], NA(yyvsp[0].ribarray)[1], NA(yyvsp[0].ribarray)[2], NA(yyvsp[0].ribarray)[3],
				NA(yyvsp[0].ribarray)[4], NA(yyvsp[0].ribarray)[5], NA(yyvsp[0].ribarray)[6] );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 124:
#line 804 "ribparse.y"
{
	RiSolidBegin( yyvsp[0].string );
;
    break;}
case 125:
#line 808 "ribparse.y"
{
	RiSolidEnd();
;
    break;}
case 126:
#line 812 "ribparse.y"
{
	RiSphereV( yyvsp[-4].num, yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 127:
#line 816 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[-1].ribarray, 4, "Sphere" ))
		RiSphereV( NA(yyvsp[-1].ribarray)[0], NA(yyvsp[-1].ribarray)[1], NA(yyvsp[-1].ribarray)[2], NA(yyvsp[-1].ribarray)[3], CPS, CPT, CPA );
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 128:
#line 822 "ribparse.y"
{
	RiSurfaceV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 129:
#line 826 "ribparse.y"
{
	RiTextureCoordinates( yyvsp[-7].num, yyvsp[-6].num, yyvsp[-5].num, yyvsp[-4].num,
						  yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 130:
#line 831 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 8, "TextureCoordinates" ))
		RiTextureCoordinates( NA(yyvsp[0].ribarray)[0], NA(yyvsp[0].ribarray)[1], NA(yyvsp[0].ribarray)[2], NA(yyvsp[0].ribarray)[3],
							  NA(yyvsp[0].ribarray)[4], NA(yyvsp[0].ribarray)[5], NA(yyvsp[0].ribarray)[7], NA(yyvsp[0].ribarray)[8] );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 131:
#line 838 "ribparse.y"
{
	RiTorus( yyvsp[-5].num, yyvsp[-4].num, yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 132:
#line 842 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[-1].ribarray, 5, "Torus" ))
		RiTorus( NA(yyvsp[-1].ribarray)[0], NA(yyvsp[-1].ribarray)[1], NA(yyvsp[-1].ribarray)[2], NA(yyvsp[-1].ribarray)[3], NA(yyvsp[-1].ribarray)[4],
			CPS, CPT, CPA );
    ArrayFree(yyvsp[-1].ribarray);
;
    break;}
case 133:
#line 849 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 16, "Transform" ))
		RiTransform( (RtFloat *) yyvsp[0].ribarray->array );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 134:
#line 855 "ribparse.y"
{
	RiTransformBegin();
;
    break;}
case 135:
#line 859 "ribparse.y"
{
	RiTransformEnd();
;
    break;}
case 136:
#line 863 "ribparse.y"
{
	RiTranslate( yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 137:
#line 867 "ribparse.y"
{
	RtInt *ncurves, *order, *n;

	ncurves = MakeIntArray( yyvsp[-8].ribarray );
	order = MakeIntArray( yyvsp[-7].ribarray );
	n = MakeIntArray( yyvsp[-3].ribarray );

	RiTrimCurve( yyvsp[-8].ribarray->nelems, ncurves, order, NA(yyvsp[-6].ribarray), NA(yyvsp[-5].ribarray), NA(yyvsp[-4].ribarray), n, NA(yyvsp[-2].ribarray), NA(yyvsp[-1].ribarray), NA(yyvsp[0].ribarray) );
	delete [] ncurves;
	delete [] order;
	delete [] n;

	ArrayFree( yyvsp[-8].ribarray );
	ArrayFree( yyvsp[-7].ribarray );
	ArrayFree( yyvsp[-6].ribarray );
	ArrayFree( yyvsp[-5].ribarray );
	ArrayFree( yyvsp[-4].ribarray );
	ArrayFree( yyvsp[-3].ribarray );
	ArrayFree( yyvsp[-2].ribarray );
	ArrayFree( yyvsp[-1].ribarray );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 138:
#line 890 "ribparse.y"
{
	RiWorldBegin();
;
    break;}
case 139:
#line 894 "ribparse.y"
{
	RiWorldEnd();
;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 543 "/usr/local/share/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
#line 897 "ribparse.y"

