#ifndef PRIMITIVES_H
#define PRIMITIVES_H
#include "lrt.h"
#include "geometry.h"
#include "shapes.h"
#include "heightfield.h"
#include "fastlevelset.h"
#include "transform.h"
#include "color.h"
#include "materials.h"
class Primitive {
public:
	virtual bool Intersect( const Ray &r, Surf *s, bool directFromEye ) const = 0;
	virtual bool IntersectP( const Ray &r ) const = 0;
	virtual BBox BoundWorldSpace() const = 0;
	virtual bool CanIntersect() const;
	virtual void Refine(vector<Primitive *> &refined) const;
	virtual ~Primitive();
};
class GeometricPrimitive: public Primitive {
public:
	GeometricPrimitive(Shape *s, Material *m, AreaLight *area = NULL);
	
	bool CanIntersect() const;
	void Refine(vector<Primitive *> &refined) const;
	virtual BBox BoundWorldSpace() const;
	virtual bool Intersect( const Ray &r, Surf *surf, bool directFromEye ) const;
	virtual bool IntersectP( const Ray &r ) const;
	Shape *shape;
	Material *material;
	AreaLight *areaLight;
};
struct Surf {
	Surf() { primitive = NULL; }
	BSDF *getBSDF() const;
	Spectrum Le(const Vector &wo) const;
	DifferentialGeometry dgGeom;
	DifferentialGeometry dgShading;
	const GeometricPrimitive *primitive;
};
class PrimitiveSet: public Primitive {
public:
	PrimitiveSet(const vector<Primitive *> &p);
	int NumPrims() const { return prims.size(); }
	const Primitive *GetPrim( int i ) const;
	BBox BoundWorldSpace() const { return bounds; }
protected:
	vector<Primitive *> prims;
	BBox bounds;
};
#endif // PRIMITIVES_H
