#ifndef HEIGHTFIELD_H
#define HEIGHTFIELD_H
#include "shapes.h"

class Heightfield : public Shape {
public:
	Heightfield(const Transform &o2w, int nu, int nv, float *zs);
	~Heightfield();
	virtual bool CanIntersect() const;
	virtual BBox Bound() const;
	virtual bool Intersect(const Ray &ray, DifferentialGeometry *dg) const;
	virtual bool IntersectP(const Ray &ray) const;

private:
	float *z;
	float minz, maxz;
	Normal *n;
	int nx, ny;
	Float dx, dy;
	float *smoothz;
	float maxSmoothGradX, maxSmoothGradY, maxSmoothError;

	void BoundZ (void);
	void ConstructVertexNormals (void);
	void ConstructSmoothApproximation (int iterations=0);
	bool PrepareLocalRay (const Ray &worldray, Ray &localray, Float &invDx, Float &invDy) const;
	bool StepUsingSmooth (int &i, int &j, Ray &ray) const;
	bool LocalIntersect (int i, int j, const Ray &ray, DifferentialGeometry *dg) const;
	bool LocalIntersectP (int i, int j, const Ray &ray) const;
};

#endif
