#ifndef FASTLEVELSET_H
#define FASTLEVELSET_H
#include "shapes.h"


class FastLevelSet : public Shape {
public:
	FastLevelSet (const Transform &o2w, const char *filename, bool dv, int smoothingIts, const char *texname, Float texwidth, Float texmag = 1);
	~FastLevelSet();
	virtual bool CanIntersect() const;
	virtual BBox Bound() const;
	virtual bool Intersect(const Ray &ray, DifferentialGeometry *dg) const;
	virtual bool IntersectP(const Ray &ray) const;

private:

	// private types
	struct PointData {Float phi, phix, phiy, phiz, phixy, phixz, phiyz, phixyz;};
	typedef PointData *pointer_to_pd;

	// private data
	int N, Ncoarse, Nsub; // N = Ncoarse*Nsub
	PointData **coarse_raw; // Ncoarse^3 grid of Float[Nsub^3] grids or NULLs
	Float dx, coarsedx;
	Float overdx, overcoarsedx;
	int Ntex;
	Float *tex_raw;
	Float tex_width, tex_dx, tex_overdx, tex_mag;

	// private members
	pointer_to_pd &coarse (const int i, const int j, const int k);
	const pointer_to_pd &coarse (const int i, const int j, const int k) const;
	PointData &fine (PointData *block, const int i, const int j, const int k);
	const PointData &fine (const PointData *block, const int i, const int j, const int k) const;
	Float &tex (int i, int j, int k);
	const Float &tex (int i, int j, int k) const;

	Float evaltex (Float x, Float y, Float z) const; // x y and z are from [0,1]
	Vector evaltexgrad (Float x, Float y, Float z) const; // x y and z are from [0,1]
	Float fastEval (const PointData *block, Float fx, Float fy, Float fz) const;
	Float eval (const PointData *block, Float fx, Float fy, Float fz) const;
	Vector evalGradient (const PointData *block, Float fx, Float fy, Float fz) const;

	bool finddata (int i, int j, int k, int fi, int fj, int fk, pointer_to_pd &phi);
	void prepareFirstDerivs (const int i, const int j, const int k);
	void prepareSecondDerivs (const int i, const int j, const int k);
	void prepareThirdDeriv (const int i, const int j, const int k);
	void smoothFirstDerivsForward (const int i, const int j, const int k);
	void smoothFirstDerivsBackward (const int i, const int j, const int k);
	bool prepareLocalRay (const Ray &worldray, Ray &ray, Float &invDx, Float &invDy, Float &invDz) const;
	bool intersectCoarse (const Ray &ray, Float invDx, Float invDy, Float invDz, int &i, int &j, int &k) const;
	bool intersectFine (int i, int j, int k, const Ray &ray, Float localmaxt, Float invD2) const;
};

#endif

