function showimage (M,index,useoldfigure)

if nargin < 3 
  useoldfigure = 0;
end
if ~useoldfigure
  figure;
end;

img = M.images(index);

X = double(imread(img.name));
X = (X/255).^.4;
image(X);
hold on

pts = img.imagepoints;
for i = 1:size(pts,1)
  id = pts(i,1);
  x = pts(i,2);
  y = pts(i,3);
  plot(x,y,'ro');
  h = text(x+6,y,int2str(id));
  set(h,'color',[1 0 0]);
end

title ([int2str(index) ' - ' img.name]);

hold off;

