% [knownpoints,points] = pointsfromcams (M, persp, knowncams, points, knownpoints0, groundpoints)
function [knownpoints,points] = pointsfromcams (M, persp, knowncams, points, knownpoints0, groundpoints)

n = M.maxpoint;
Q = zeros(4,4,n);

for p = groundpoints
  Q(:,:,p) = Q(:,:,p) + 10*[0 0 0 0; 0 1 0 0; 0 0 0 0; 0 0 0 0];
end

for i = size(knownpoints0,1)
  p = knownpoints0(i,1);
  Q(:,:,p) = Q(:,:,p) + 10*[1 0 0 -knownpoints0(i,2);
                            0 1 0 -knownpoints0(i,3);
                            0 0 1 -knownpoints0(i,4);
                            -knownpoints0(i,2:4) norm(knownpoints0(i,2:4))^2];
end

for i = 1:size(knowncams,1)
  c = knowncams(i,1);
  camxyz = knowncams(i,2:4)';
  sh = sin(pi/180*knowncams(i,5)); ch = cos(pi/180*knowncams(i,5)); % heading
  sp = sin(pi/180*knowncams(i,6)); cp = cos(pi/180*knowncams(i,6)); % pitch
  sr = sin(pi/180*knowncams(i,7)); cr = cos(pi/180*knowncams(i,7)); % roll
  camR = [1 0 0; 0 cr -sr; 0 sr cr] * [cp -sp 0; sp cp 0; 0 0 1] * [ch 0 sh; 0 1 0; -sh 0 ch];
  photo = M.images(c);
  w = photo.width;
  h = photo.height;
  weight = (min(5,knowncams(i,8)));
  for j = 1:size(photo.imagepoints,1)
    p = photo.imagepoints(j,1);
	photoxyz = [persp; -2*(photo.imagepoints(j,3)-h/2)/w; 2*(photo.imagepoints(j,2)-w/2)/w];
	dir = camR'*photoxyz;
	dir = dir/norm(dir);
    proj = eye(3)-dir*dir';
	thisQ = [proj -proj*camxyz; -camxyz'*proj camxyz'*proj*camxyz];
	if any(eigs(thisQ) < -1e-12)
	  fprintf(1,'indefinite least-squares matrix for point %d, image %d\n', p, c);
	  thisQ;
	end
	Q(:,:,p) = Q(:,:,p) + weight*thisQ;
  end
end

knownpoints = [];
for j = 1:n
  if cond(Q(1:3,1:3,j)) < 1e12
    knownpoints(end+1,:) = [j (-Q(1:3,1:3,j)\Q(1:3,4,j))'];
  end
end

knownindex = zeros(n,1);
knownindex(knownpoints(:,1)) = 1:size(knownpoints,1);

for i = 1:size(knownpoints0,1)
  p = knownpoints0(i,1);
  if knownindex(p) ~= 0
    knownpoints(knownindex(p),2:4) = knownpoints0(i,2:4);
  else
    fprintf(1,'known point %d undetermined!\n', p);
	knownpoints(end+1,:) = knownpoints0(i,:);
  end
end

for p = groundpoints
  if knownindex(p) ~= 0
    knownpoints(knownindex(p),3) = 0;
  end
end

for i = 1:size(knownpoints,1)
  p = knownpoints(i,1);
  if knownpoints(i,3) < 0
    knownpoints(i,3) = 0;
  end
  points(p,1:3) = knownpoints(i,2:4);
end

% finally figure out a measure of uncertainty for each point
for i = 1:size(knownpoints,1)
  p = knownpoints(i,1);
  xyz1 = [knownpoints(i,2:4) 1]';
  knownpoints(i,5) = 1/(sqrt(max(0,xyz1'*Q(:,:,p)*xyz1))+.01);
end

for i = 1:size(knownpoints0,1)
  p = knownpoints0(i,1);
  if knownindex(p) ~= 0
    knownpoints(knownindex(p),5) = 999;
  end
end

