
#ifndef TRANSPORT_H
#define TRANSPORT_H
#include "lrt.h"

class Integrator {
  public:

	virtual ~ Integrator();

	virtual Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
							   Float * hitDist, Float * alpha) const = 0;

};

class ColorIntegrator:public Integrator { public:
	Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
					   Float * hitDist, Float * alpha) const;
};

class RayCastingIntegrator:public Integrator { public:
	Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
					   Float * hitDist, Float * alpha) const;
};

class WhittedIntegrator:public Integrator { public:
	Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
					   Float * hitDist, Float * alpha) const;
	static int RayDepth;
};

class MCIntegrator:public Integrator { public:
	Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
					   Float * hitDist, Float * alpha) const;
};

class RendermanIntegrator:public Integrator { public:
	Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
					   Float * hitDist, Float * alpha) const;
  private:
	 mutable StringHashTable shaders;
};

class PhotonIntegrator:public Integrator
{ 
 public:
  static int RayDepth;

  Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
		     Float * hitDist, Float * alpha) const;
};


class PhotonDebugIntegrator:public Integrator { public:
	Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
					   Float * hitDist, Float * alpha) const;
	static int RayDepth;
	static int taggedPhotons;
	~PhotonDebugIntegrator() 
	{ 
	  cerr << "Tagged photons: " 
		  << taggedPhotons << endl;
  }

	// for debugging
  void printFoundPhoton( 
    vector< pair<Float,Photon *> > &photonPairs) const ; 

};

#endif // TRANSPORT_H
