#include "dal.h"

DirectionalAreaLight::DirectionalAreaLight( Scene &scene, 
  Spectrum power, Float height, Float theta, Float phi) 
  : sceneBoundary(Point(0.),Point(0.))
{
  //set light direction
  this->power = power;
  this->height = height;
  this->theta = theta;
  this->phi = phi;

  // compute scene bounding box
  const vector < Primitive* > primList = scene.GetPrimitives();
  // get initial bbox from first primitive
  assert (primList.size() >=1);
  sceneBoundary = primList[0]->BoundWorldSpace();
  for (unsigned int i=1; i<primList.size(); i++)
  {
    sceneBoundary = Union(primList[i]->BoundWorldSpace(),
      sceneBoundary);
  }

  dimU = sceneBoundary.pMax.x - sceneBoundary.pMin.x;
  dimV = sceneBoundary.pMax.y - sceneBoundary.pMin.y;

	// scale dim to avoid float point errors ?
	dimU *=0.999;
	dimV *=0.999;

  Float halfHeight = 
	  (sceneBoundary.pMax.z - sceneBoundary.pMin.z)/2.;
  
	// lrt uses left handed system where positive z is 
	//   downward
  //lightZ = -height + sceneBoundary.pMin.z;
  //lightZ = height + sceneBoundary.pMax.z;
  lightZ = sceneBoundary.pMin.z;

  Float radius = (height+halfHeight)*tan(phi); 
  lightOffsetX = sceneBoundary.pMin.x + cos(theta)*radius;
  lightOffsetY = sceneBoundary.pMin.y + sin(theta)*radius;

  // set light direction
  lightDir = Vector(-sin(phi)*cos(theta),
    -sin(phi)*sin(theta), cos(phi));
  //  -sin(phi)*sin(theta), -cos(phi));
  
}
 
Spectrum DirectionalAreaLight::dE(
  const Point& Ps, Point *Plight) const
{
  cerr << "Why are you calling me ... i'm a"  
    "DirectionalAreaLight source" << endl;
  
  *Plight = Ps + 1000. * lightDir;
  
  return power;
}

Point DirectionalAreaLight::Sample(Float u[2])
{
  //static int count = 0;
 
  Float x = dimU*u[0];
  Float y = dimV*u[1];
  
  x += lightOffsetX;
  y += lightOffsetY;

  return Point(x,y,lightZ);
#if 0
	Ray lightRay = Ray(Point(x,y,lightZ), lightDir);
  return Point(x,y,lightZ);
	Float t=INFINITY;

	if (sceneBoundary.IntersectP(lightRay,&t)
	  != true)
  {
	  cerr << "dal.cc: light did not hit scene boundary, " 
		  << ++count << endl;
	}

  return lightRay(t);
#endif
}
