
#ifndef TRANSPORT_H
#define TRANSPORT_H
#include "lrt.h"

class Integrator {
  public:

	virtual ~ Integrator();

	virtual Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
							   Float * hitDist, Float * alpha) const = 0;

};

class ColorIntegrator:public Integrator { public:
	Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
					   Float * hitDist, Float * alpha) const;
};

class RayCastingIntegrator:public Integrator { public:
	Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
					   Float * hitDist, Float * alpha) const;
};

class WhittedIntegrator:public Integrator { public:
	Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
					   Float * hitDist, Float * alpha) const;
	static int RayDepth;
};

class MCIntegrator:public Integrator { public:
	Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
					   Float * hitDist, Float * alpha) const;
	Spectrum MCIntegrator::ComputeRayLuminance( const Ray &lightRay, Spectrum dE, float step ) const;
	float MCIntegrator::opacity(Point p) const;
	float MCIntegrator::phase(const Ray &eyeRay, const Ray &lightRay) const;
	static int RayDepth;
};

class RendermanIntegrator:public Integrator { public:
	Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
					   Float * hitDist, Float * alpha) const;
  private:
	 mutable StringHashTable shaders;
};

#endif // TRANSPORT_H
