
#ifndef SAMPLING_H
#define SAMPLING_H
#include "lrt.h"

#define SQRT_SAMPLE_TABLE_SIZE 32
#define SAMPLE_TABLE_SIZE (SQRT_SAMPLE_TABLE_SIZE * SQRT_SAMPLE_TABLE_SIZE)

class Sampler {
  public:
	virtual ~ Sampler() {
	} virtual bool GetNextImageSample(Float sample[5]) = 0;

};

class JitterSampler:public Sampler {
  public:

	JitterSampler(const Options & options);

	bool GetNextImageSample(Float sample[5]);

  private:

	int XMax, YMax;
	Float DeltaX, DeltaY;
	bool JitterSamples;

	int XPos, YPos;

};

class GeneralSampler:public Sampler { public:
	 GeneralSampler(const Options &);

	bool GetNextImageSample(Float sample[5]);

  private:

	const Options & options;
	static const Float sampleTable[SAMPLE_TABLE_SIZE][5];
	int tablePos;
	Float x0, y0;
	Float DeltaX, DeltaY;

};

extern Float BoxFilter(Float x, Float y, Float xwidth, Float ywidth);

extern Float TriangleFilter(Float x, Float y, Float xwidth, Float ywidth);

extern Float GaussianFilter(Float x, Float y, Float xwidth, Float ywidth);

extern Float MitchellFilter(Float x, Float y, Float xwidth, Float ywidth);

#endif // SAMPLING_H
