
#ifndef OPTIONS_H
#define OPTIONS_H
#include "lrt.h"
#include "transform.h"
struct Options {

	Options();

	void FinalizeValues();

	int XResolution, YResolution;

	Float ScreenLeft, ScreenRight, ScreenBottom, ScreenTop;

	Float ClipHither, ClipYon;

	Float ShutterStart, ShutterEnd;

	Float FStop, FocalLength, FocalDistance;

	Transform WorldToCamera;
	Transform CameraToScreen;
	enum { Orthographic, Perspective } ProjectionType;

	Float CropLeft, CropRight, CropBottom, CropTop;

	int RasterCropLeft, RasterCropRight;
	int RasterCropTop, RasterCropBottom;
	Float SampleCropLeft, SampleCropRight;
	Float SampleCropTop, SampleCropBottom;

	Float PixelSamples[2];

	bool JitterSamples;

	Float FilterXWidth, FilterYWidth;

	RtFilterFunc Filter;

	Float PixelAspectRatio, FrameAspectRatio;

	RtToken IlluminationIntegrator;

	RtToken DisplayMode;

	Float Gain, Gamma;

	RtToken Imager;

	int ColorQuantOne, ColorQuantMin, ColorQuantMax;
	Float ColorQuantDither;

	int DepthQuantOne, DepthQuantMin, DepthQuantMax;
	Float DepthQuantDither;

	RtToken DisplayType, DisplayName;

	char *ImageViewer;

};
#endif // OPTIONS_H
