
#include "options.h"

Options::Options()
{

	XResolution = 640;
	YResolution = 480;

	ScreenLeft = -4. / 3.;
	ScreenBottom = -1;
	ScreenRight = 4. / 3.;
	ScreenTop = 1.;

	ClipHither = 1e-2;
	ClipYon = RI_INFINITY;

	ShutterStart = 0.;
	ShutterEnd = 1.;

	FStop = RI_INFINITY;
	FocalLength = FocalDistance = RI_INFINITY;

	ProjectionType = Perspective;

	CropLeft = CropBottom = 0.;
	CropRight = CropTop = 1.;

	PixelSamples[0] = PixelSamples[1] = 2.;

	JitterSamples = true;

	FilterXWidth = FilterYWidth = 2.0;

	Filter = RiGaussianFilter;

	PixelAspectRatio = 1.;
	FrameAspectRatio = 4. / 3.;

	IlluminationIntegrator = LRT_WHITTED;

	DisplayMode = RI_RGBA;

	Gain = Gamma = 1.;

	Imager = RI_NULL;

	ColorQuantOne = 255;
	ColorQuantMin = 0;
	ColorQuantMax = 255;
	ColorQuantDither = 0.5;

	DepthQuantOne = 0;
	DepthQuantMin = 0;
	DepthQuantMax = 0;
	DepthQuantDither = 0.;

	DisplayType = RI_FILE;
	DisplayName = "out.tiff";

	ImageViewer = NULL;

}

void Options::FinalizeValues()
{

	RasterCropLeft =
		(int) Clamp(ceil(XResolution * CropLeft), 0, XResolution);
	RasterCropRight =
		(int) Clamp(ceil(XResolution * CropRight), 0, XResolution);
	RasterCropBottom =
		(int) Clamp(ceil(YResolution * CropBottom), 0, YResolution);
	RasterCropTop =
		(int) Clamp(ceil(YResolution * CropTop), 0, YResolution);
	SampleCropLeft = Clamp(RasterCropLeft - FilterXWidth, 0., XResolution);
	SampleCropRight =
		Clamp(RasterCropRight + FilterXWidth, 0., XResolution);
	SampleCropBottom =
		Clamp(RasterCropBottom - FilterYWidth, 0., YResolution);
	SampleCropTop = Clamp(RasterCropTop + FilterYWidth, 0., YResolution);

}
