
#ifndef IMAGE_H
#define IMAGE_H
#include "lrt.h"
#include "color.h"

class Image {
  public:

	Image(const Options & opt);

	~Image();

	void AddSampleBasic(const Point & PRaster, const Spectrum & radiance,
						Float alpha);

	void Write() const;

	void AddSample(const Point & PRaster, const Spectrum & radiance,
				   Float alpha);

  private:

	static void scaleAndDither(Float one, Float min, Float max,
							   Float dither, Float * pixels, int nPixels);

	int XBase, YBase, XDelta, YDelta;
	const Options & options;

	Spectrum *Pixels;
	Float *Alphas, *Depths;
	Float *WeightSums;

};

#endif // IMAGE_H
