
#ifndef HEIGHTFIELD_H
#define HEIGHTFIELD_H
#include "primitives.h"
#include "trimesh.h"

class Heightfield:public Primitive {
  public:

	Heightfield(int nu, int nv, float *zs, PrimitiveAttributes * a,
				SurfaceFunction * sf);
	~Heightfield();
	bool IntersectClosest(const Ray & ray, Float mint, Float * maxt,
						  HitInfo * hit) const;
	float xVal2x(int x) const;
	float yVal2y(int y) const;
	virtual bool CanIntersect() const;
	virtual void Refine(vector < Primitive * >*refined) const;
	virtual BBox BoundObjectSpace() const;

  private:
	 float *z;
	 TriangleMesh **M;
	int nx, ny;

};

#endif // HEIGHTFIELD_H
