
#ifndef CAMERA_H
#define CAMERA_H
#include "lrt.h"
#include "color.h"
#include "sampling.h"
#include "geometry.h"
#include "transform.h"

class Camera {
  public:

	Camera(const Options &);

	void RenderImage(Scene & scene, const Integrator & integrator) const;

  private:
	 const Options & options;
	Float invClipHither;

	Transform WorldToCamera, CameraToWorld;
	Transform CameraToScreen, ScreenToCamera;
	Transform ScreenToRaster, RasterToScreen;
	Transform RasterToCamera;
	Transform WorldToScreen;

};

#endif // CAMERA_H
