#include "geometry.h"

class Density {
 public: 

  // return the perlin noise at a point
  Density(int n, BBox bounds);

  // generate Perlin noise in 3d
  float noise3D(int x, int y, int z);
  float smoothNoise3D(int x, int y, int z);
  
  void generatePerlinGrid(float mean);
  // compute the density at the point
  float grid(Point p);

  // interpolation
  float interpolate(float a, float b, float x);
  float interpolate3D(float x, float y, float z, float corners[]);

 private:

  // grid of noise values
  float *noise;
  int points,points2;
  BBox *gridBoundary;
  float voxelX, voxelY, voxelZ;
};
